/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.InjectionManager;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.ACCEntityResolver;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.appclient.HttpAuthenticator;
import com.sun.enterprise.appclient.MainWithModuleSupport;
import com.sun.enterprise.appclient.jws.Util;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansFactory;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.config.clientbeans.ClientCredential;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.Security;
import com.sun.enterprise.config.clientbeans.Ssl;
import com.sun.enterprise.config.clientbeans.TargetServer;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.naming.ProviderManager;
import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.server.logging.ACCLogManager;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;

public class Main {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String MAIN_CLASS = "-mainclass";
    private static final String TEXT_AUTH = "-textauth";
    private static final String XML_PATH = "-xml";
    private static final String ACC_CONFIG_XML = "-configxml";
    private static final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";
    private static final String NO_APP_INVOKE = "-noappinvoke";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String PASSWORD_FILE = "-passwordfile";
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static final String DASH = "-";
    private static final String lineSep = System.getProperty("line.separator");
    public static final String APPCLIENT_IIOP_DEFAULTHOST_PROPERTYNAME = "com.sun.aas.jws.iiop.defaultHost";
    public static final String APPCLIENT_IIOP_DEFAULTPORT_PROPERTYNAME = "com.sun.aas.jws.iiop.defaultPort";
    public static final String APPCLIENT_IIOP_FAILOVER_ENDPOINTS_PROPERTYNAME = "com.sun.aas.jws.iiop.failover.endpoints";
    public static final String APPCLIENT_PROBE_CLASSNAME_PROPERTYNAME = "com.sun.aas.jws.probeClassName";
    public static final String APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME = "com.sun.aas.jws.retainTempFiles";
    public static final String APPCLIENT_ISJWS_PROPERTYNAME = "com.sun.aas.jws.isJWS";
    public static final String SUN_ACC_SECURITY_CONFIG_PROPERTY = "security.config.file";
    private static final String LOGIN_CONF_FILE_PREFIX = "login";
    private static final String LOGIN_CONF_FILE_SUFFIX = ".conf";
    private static final String LOGIN_CONF_PROPERTY_NAME = "java.security.auth.login.config";
    private static final String DEFAULT_TEMPLATE_PREFIX = "jws/templates/";
    private static final String SUN_ACC_DEFAULT_TEMPLATE = "jws/templates/default-sun-accTemplate.xml";
    private static final String WSS_CLIENT_CONFIG_TEMPLATE = "jws/templates/default-wss-client-configTemplate.xml";
    private static final String LOGIN_CONF_TEMPLATE = "jws/templates/appclientlogin.conf";
    private static final String WSS_CLIENT_CONFIG_PREFIX = "wsscc";
    private static final String WSS_CLIENT_CONFIG_SUFFIX = ".xml";
    private static final String SUN_ACC_PREFIX = "sunacc";
    private static final String SUN_ACC_SUFFIX = ".xml";
    private static Logger _logger;
    private static final boolean debug = false;
    private static StringManager localStrings;
    private static boolean guiAuth;
    private static boolean runClient;
    private static String host;
    private static String port;
    private static StringBuilder pendingLogInfo;
    private static StringBuilder pendingLogFine;
    private static String[] args;
    private static boolean isJWS;
    private static boolean retainTempFiles;
    private static final String SUPPORT_MODULE_FORMAT = "support.module.format";
    private static final String SUPPORT_MODULE_FORMAT_DEFAULT_VALUE = "true";
    private static final String supportModuleFormatValue;
    private static final boolean supportModuleFormat;
    private static boolean lb_enabled;

    public static void main(String[] args) {
        if (supportModuleFormat) {
            new MainWithModuleSupport(args);
        } else {
            new Main(args);
        }
    }

    public Main(String[] args) {
        String arg = null;
        String clientJar = null;
        String displayName = null;
        String mainClass = null;
        String xmlPath = null;
        String accConfigXml = null;
        String jwsACCConfigXml = null;
        Vector<String> appArgs = new Vector<String>();
        int i = 0;
        isJWS = Boolean.getBoolean(APPCLIENT_ISJWS_PROPERTYNAME);
        retainTempFiles = Boolean.getBoolean(APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME);
        guiAuth = Boolean.valueOf(System.getProperty("auth.gui", SUPPORT_MODULE_FORMAT_DEFAULT_VALUE));
        if (args.length < 1) {
            Main.usage();
        } else {
            while (i < args.length) {
                if ((arg = args[i++]).equals(CLIENT)) {
                    if (i < args.length && !args[i].startsWith(DASH)) {
                        clientJar = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(NAME) && !args[i].startsWith(DASH)) {
                    if (i < args.length && mainClass == null) {
                        displayName = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(MAIN_CLASS) && !args[i].startsWith(DASH)) {
                    if (i < args.length && displayName == null) {
                        mainClass = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(XML_PATH)) {
                    if (i < args.length && xmlPath == null) {
                        xmlPath = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(ACC_CONFIG_XML)) {
                    if (i < args.length && accConfigXml == null) {
                        accConfigXml = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(TEXT_AUTH)) {
                    guiAuth = false;
                    continue;
                }
                if (arg.equals(NO_APP_INVOKE)) {
                    runClient = false;
                    continue;
                }
                if (arg.equals(USER)) {
                    if (i < args.length) {
                        System.setProperty(LOGIN_NAME, args[i++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(PASSWORD)) {
                    if (i < args.length) {
                        System.setProperty(LOGIN_PASSWORD, args[i++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(PASSWORD_FILE)) {
                    if (i < args.length) {
                        try {
                            System.setProperty(LOGIN_PASSWORD, this.loadPasswordFromFile(args[i++]));
                            continue;
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException(ex.getMessage());
                        }
                    }
                    Main.usage();
                    continue;
                }
                appArgs.add(arg);
            }
        }
        String uname = System.getProperty(LOGIN_NAME);
        String upass = System.getProperty(LOGIN_PASSWORD);
        if (uname != null || upass != null) {
            UsernamePasswordStore.set(uname, upass);
        }
        String className = null;
        if (clientJar == null && !isJWS) {
            String value;
            String path;
            File file;
            if (appArgs.size() == 0 && mainClass == null) {
                Main.usage();
            }
            if (!(file = new File(path = (className = (value = mainClass == null ? (String)appArgs.elementAt(0) : mainClass).endsWith(".class") ? value.substring(0, value.length() - ".class".length()) : value).replace('.', File.separatorChar) + ".class")).isAbsolute()) {
                file = new File(System.getProperty("user.dir"), path);
            }
            if (!file.exists() && !isJWS) {
                Main.usage();
            }
        }
        if (xmlPath != null) {
            Main.validateXMLFile(xmlPath);
        } else if (accConfigXml != null) {
            Main.validateXMLFile(accConfigXml);
            xmlPath = accConfigXml;
        } else if (isJWS) {
            try {
                jwsACCConfigXml = this.prepareJWSConfig();
                if (jwsACCConfigXml != null) {
                    Main.validateXMLFile(jwsACCConfigXml);
                    xmlPath = jwsACCConfigXml;
                }
            }
            catch (Throwable thr) {
                System.err.println("Error preparing configuration");
                thr.printStackTrace(System.err);
                System.exit(1);
            }
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");
        LogManager logMgr = LogManager.getLogManager();
        if (logMgr instanceof ACCLogManager) {
            ((ACCLogManager)logMgr).init(xmlPath);
        }
        if (pendingLogInfo.length() > 0) {
            _logger.info(pendingLogInfo.toString());
            if (pendingLogFine.length() > 0) {
                _logger.fine(pendingLogFine.toString());
            }
        }
        if (isJWS) {
            try {
                this.prepareJWSLoginConfig();
            }
            catch (Throwable thr) {
                _logger.log(Level.SEVERE, "Error preparing default login configuration", thr);
                System.exit(1);
            }
        }
        Utility.checkJVMVersion();
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
            J2EESecurityManager mgr = new J2EESecurityManager();
            System.setSecurityManager(mgr);
        }
        if (_logger.isLoggable(Level.INFO)) {
            if (secMgr != null) {
                _logger.info("acc.secmgron");
            } else {
                _logger.info("acc.secmgroff");
            }
        }
        try {
            SSLUtils.initStoresAtStartup();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "main.ssl_keystore_init_failed", e);
            }
            _logger.log(Level.WARNING, "main.ssl_keystore_init_failed");
        }
        try {
            String defaultFactory = java.security.Security.getProperty("authconfigprovider.factory");
            if (defaultFactory == null) {
                java.security.Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "main.jmac_default_factory");
        }
        try {
            File appClientFile;
            Switch.getSwitch().setProviderManager(ProviderManager.getProviderManager());
            Main.setTargetServerProperties(xmlPath);
            boolean exitCode = false;
            AppContainer container = null;
            Cleanup cleanup = new Cleanup();
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(cleanup);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
                    return null;
                }
            });
            if (isJWS) {
                appClientFile = this.findAppClientFileForJWSLaunch();
            } else if (clientJar == null) {
                File userDir = new File(System.getProperty("user.dir"));
                File appClientClass = new File(userDir, className);
                appClientFile = appClientClass.getParentFile();
            } else {
                appClientFile = new File(clientJar);
            }
            URL[] urls = new URL[]{appClientFile.toURI().toURL()};
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            URLClassLoader jcl = new URLClassLoader(urls, currentCL);
            Thread.currentThread().setContextClassLoader(jcl);
            ApplicationClientDescriptor appDesc = null;
            if ((clientJar != null || isJWS) && FileUtil.isEARFile(appClientFile)) {
                Application app = null;
                try {
                    ApplicationArchivist arch = new ApplicationArchivist();
                    arch.setAnnotationProcessingRequested(true);
                    arch.setClassLoader(jcl);
                    app = (Application)arch.open(appClientFile);
                }
                catch (Throwable t) {
                    _logger.log(Level.WARNING, "acc.failed_load_client_desc", clientJar);
                    throw t;
                }
                app.setClassLoader(jcl);
                appDesc = null;
                int appclientCount = 0;
                for (ApplicationClientDescriptor next : app.getApplicationClientDescriptors()) {
                    ++appclientCount;
                }
                for (ApplicationClientDescriptor next : app.getApplicationClientDescriptors()) {
                    if (appclientCount == 1) {
                        if (mainClass != null && !next.getMainClassName().equals(mainClass)) {
                            next.setMainClassName(mainClass);
                        }
                        appDesc = next;
                        break;
                    }
                    if (mainClass != null) {
                        if (!next.getMainClassName().equals(mainClass)) continue;
                        appDesc = next;
                        break;
                    }
                    if (displayName == null) {
                        _logger.log(Level.SEVERE, "acc.no_mainclass_or_displayname");
                        System.exit(1);
                        continue;
                    }
                    if (displayName == null || !next.getName().equals(displayName)) continue;
                    if (appDesc == null) {
                        appDesc = next;
                        continue;
                    }
                    _logger.log(Level.WARNING, "acc.duplicate_display_name");
                    System.exit(1);
                }
                if (appDesc != null) {
                    container = new AppContainer(appDesc, guiAuth);
                }
            } else {
                try {
                    AppClientArchivist arch = new AppClientArchivist();
                    arch.setAnnotationProcessingRequested(true);
                    arch.setClassLoader(jcl);
                    appDesc = className != null ? (ApplicationClientDescriptor)arch.getDefaultBundleDescriptor() : (ApplicationClientDescriptor)arch.open(appClientFile.getAbsolutePath());
                    if (className != null) {
                        AbstractArchive archive;
                        if (appClientFile.isDirectory()) {
                            archive = new FileArchive();
                            ((FileArchive)archive).open(appClientFile.getAbsolutePath());
                        } else {
                            archive = new InputJarArchive();
                            ((InputJarArchive)archive).open(appClientFile.getAbsolutePath());
                        }
                        if (appDesc.getMainClassName() == null || appDesc.getMainClassName().length() == 0) {
                            appDesc.setMainClassName(className);
                            arch.processAnnotations(appDesc, archive);
                            if (mainClass == null && !isJWS) {
                                appArgs.removeElementAt(0);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    _logger.log(Level.WARNING, "main.appclient_descriptors_failed", displayName == null ? mainClass : displayName);
                    throw t;
                }
                container = new AppContainer(appDesc, guiAuth);
            }
            if (container == null) {
                _logger.log(Level.WARNING, "acc.no_client_desc", displayName == null ? mainClass : displayName);
                System.exit(1);
            }
            Authenticator.setDefault(new HttpAuthenticator(container));
            _logger.log(Level.INFO, "acc.orb_host_name", host);
            _logger.log(Level.INFO, "acc.orb_port_number", port);
            Properties props = new Properties();
            props.put("org.omg.CORBA.ORBInitialHost", host);
            props.put("org.omg.CORBA.ORBInitialPort", port);
            String appMainClass = container.preInvoke(props);
            cleanup.setAppContainer(container);
            Class<?> cl = null;
            try {
                cl = jcl.loadClass(appMainClass);
            }
            catch (ClassNotFoundException cnf) {
                String errorMessage = localStrings.getString("appclient.mainclass.not.found", appMainClass);
                _logger.log(Level.WARNING, errorMessage);
                throw cnf;
            }
            _logger.log(Level.INFO, "acc.load_app_class", appMainClass);
            String[] applicationArgs = new String[appArgs.size()];
            for (int sz = 0; sz < applicationArgs.length; ++sz) {
                applicationArgs[sz] = (String)appArgs.elementAt(sz);
            }
            if (appDesc.hasWebServiceClients()) {
                File moduleFile;
                if (appDesc.getApplication() == null || appDesc.getApplication().isVirtual()) {
                    moduleFile = appClientFile;
                } else {
                    InputJarArchive earFile = new InputJarArchive();
                    earFile.open(appClientFile.getAbsolutePath());
                    String moduleName = appDesc.getModuleDescriptor().getArchiveUri();
                    InputStream is = earFile.getEntry(moduleName);
                    moduleFile = File.createTempFile("appclient", ".jar");
                    moduleFile.deleteOnExit();
                    FileOutputStream os = new FileOutputStream(moduleFile);
                    ArchivistUtils.copy(new BufferedInputStream(is), new BufferedOutputStream(os));
                    earFile.close();
                }
                for (ServiceReferenceDescriptor serviceRef : appDesc.getServiceReferenceDescriptors()) {
                    if (serviceRef.getWsdlFileUri() == null) continue;
                    File wsdlFile = new File(serviceRef.getWsdlFileUri());
                    if (wsdlFile.isAbsolute()) {
                        serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                        continue;
                    }
                    serviceRef.setWsdlFileUrl(FileUtil.getEntryAsUrl(moduleFile, serviceRef.getWsdlFileUri()));
                }
            }
            InjectionManager injMgr = Switch.getSwitch().getInjectionManager();
            injMgr.injectClass(cl, appDesc);
            if (runClient) {
                Utility.invokeApplicationMain(cl, applicationArgs);
                _logger.info("Application main() finished normally");
            }
            injMgr.invokeClassPreDestroy(cl, appDesc);
            this.shutDownSystemAdapters();
        }
        catch (InvocationTargetException ite) {
            Throwable tt = ite.getTargetException();
            _logger.log(Level.WARNING, "acc.app_exception", tt);
            this.shutDownSystemAdapters();
            System.exit(1);
        }
        catch (Throwable t) {
            if (t instanceof FailedLoginException) {
                _logger.info("acc.login_error");
                boolean isGui = Boolean.valueOf(System.getProperty("auth.gui", SUPPORT_MODULE_FORMAT_DEFAULT_VALUE));
                String errorMessage = localStrings.getString("main.exception.loginError", "Incorrect login and/or password");
                if (isGui) {
                    GUIErrorDialog ged = new GUIErrorDialog(errorMessage);
                    ged.show();
                }
            }
            _logger.log(Level.WARNING, "acc.app_exception", t);
            if (t instanceof NamingException) {
                _logger.log(Level.WARNING, "acc.naming_exception_received");
            }
            this.shutDownSystemAdapters();
            System.exit(1);
        }
    }

    private static void setTargetServerProperties(String clientXmlLocation) throws ConfigException {
        try {
            if (clientXmlLocation == null || clientXmlLocation.equals("")) {
                clientXmlLocation = DEFAULT_CLIENT_CONTAINER_XML;
            }
            System.setProperty(SUNACC_XML_URL, clientXmlLocation);
            _logger.log(Level.INFO, "acc.using_xml_location", clientXmlLocation);
            ConfigContext ctx = ConfigFactory.createConfigContext(clientXmlLocation, true, false, false, ClientContainer.class, new ACCEntityResolver());
            ClientContainer cc = ClientBeansFactory.getClientBean(ctx);
            host = cc.getTargetServer(0).getAddress();
            port = cc.getTargetServer(0).getPort();
            TargetServer[] tServer = cc.getTargetServer();
            String targetServerEndpoints = null;
            for (int i = 0; i < tServer.length; ++i) {
                if (targetServerEndpoints == null) {
                    targetServerEndpoints = tServer[i].getAddress() + ":" + tServer[i].getPort();
                    continue;
                }
                lb_enabled = true;
                targetServerEndpoints = targetServerEndpoints + "," + tServer[i].getAddress() + ":" + tServer[i].getPort();
            }
            Main.setSSLData(cc);
            ClientCredential cCrd = cc.getClientCredential();
            if (cCrd != null) {
                String uname = null;
                String upass = null;
                if (System.getProperty(LOGIN_NAME) == null) {
                    _logger.config("using login name from client container xml...");
                    uname = cCrd.getUserName();
                }
                if (System.getProperty(LOGIN_PASSWORD) == null) {
                    _logger.config("using password from client container xml...");
                    upass = cCrd.getPassword();
                }
                if (uname != null || upass != null) {
                    UsernamePasswordStore.set(uname, upass);
                }
            }
            String endpoints_property = null;
            ElementProperty[] props = cc.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                if (props[i].getName().equals("ssl") && props[i].getValue().equals("required")) {
                    ORBManager.getCSIv2Props().put("com.sun.CSIV2.ssl.client.required", SUPPORT_MODULE_FORMAT_DEFAULT_VALUE);
                }
                if (props[i].getName().equals("com.sun.appserv.iiop.loadbalancingpolicy")) {
                    System.setProperty(props[i].getName(), props[i].getValue());
                    lb_enabled = true;
                }
                if (!props[i].getName().equals("com.sun.appserv.iiop.endpoints")) continue;
                endpoints_property = props[i].getValue().trim();
                lb_enabled = true;
            }
            String jwsEndpointsProperty = System.getProperty(APPCLIENT_IIOP_FAILOVER_ENDPOINTS_PROPERTYNAME);
            if (jwsEndpointsProperty != null) {
                targetServerEndpoints = jwsEndpointsProperty;
                lb_enabled = true;
            } else {
                _logger.warning("acc.targetserver.endpoints.warning");
            }
            _logger.fine("targetServerEndpoints = " + targetServerEndpoints + "endpoints_property = " + endpoints_property);
            if (lb_enabled && endpoints_property == null) {
                System.setProperty("com.sun.appserv.iiop.endpoints", targetServerEndpoints.trim());
            } else if (endpoints_property != null) {
                System.setProperty("com.sun.appserv.iiop.endpoints", targetServerEndpoints.trim() + "," + endpoints_property);
            }
        }
        catch (ConfigException t) {
            _logger.log(Level.WARNING, "acc.acc_xml_file_error", new Object[]{clientXmlLocation, t.getMessage()});
            _logger.log(Level.FINE, "exception : " + t.toString(), t);
            throw t;
        }
    }

    private static void setSSLData(ClientContainer cc) {
        try {
            TargetServer tServer = cc.getTargetServer(0);
            Security security = tServer.getSecurity();
            if (security == null) {
                _logger.fine("No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                _logger.fine("No SSL input set in ClientContainer.xml");
                return;
            }
            SSLUtils.setAppclientSsl(ssl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void validateXMLFile(String xmlFullName) {
        if (xmlFullName == null || xmlFullName.startsWith(DASH)) {
            Main.usage();
        }
        try {
            File f = new File(xmlFullName);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return;
            }
            Main.xmlMessage(xmlFullName);
            Main.usage();
        }
        catch (Exception ex) {
            Main.xmlMessage(xmlFullName);
            Main.usage();
        }
    }

    private void shutDownSystemAdapters() {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            if (poolmgr != null) {
                Switch.getSwitch().getPoolManager().killFreeConnectionsInPools();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ActiveResourceAdapter activeRar = registry.getActiveResourceAdapter("jmsra");
            if (activeRar != null) {
                activeRar.destroy();
            }
        }
        catch (Exception e) {
            _logger.fine("Exception caught while shutting down system adapter:" + e.getMessage());
        }
    }

    private static void usage() {
        System.out.println(localStrings.getString("main.usage", "appclient [ -client <appjar> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [app-args]"));
        System.exit(1);
    }

    private static void xmlMessage(String xmlFullName) {
        System.out.println(localStrings.getString("main.cannot_read_clientContainer_xml", xmlFullName, "Client Container xml: " + xmlFullName + " not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPasswordFromFile(String fileName) throws IOException {
        String string;
        block2: {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(fileName));
                Properties props = new Properties();
                props.load(inputStream);
                string = props.getProperty("PASSWORD");
                Object var6_5 = null;
                if (inputStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (inputStream == null) break block3;
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            ((InputStream)inputStream).close();
        }
        return string;
    }

    private String prepareJWSConfig() throws IOException, FileNotFoundException {
        return this.prepareJWSDefaultConfig();
    }

    private String prepareJWSDefaultConfig() throws IOException, FileNotFoundException {
        Object result = null;
        String sunACCTemplate = Util.loadResource(this.getClass(), SUN_ACC_DEFAULT_TEMPLATE);
        String wssClientConfigTemplate = Util.loadResource(this.getClass(), WSS_CLIENT_CONFIG_TEMPLATE);
        Properties tokenValues = new Properties(System.getProperties());
        String wssClientConfig = Util.replaceTokens(wssClientConfigTemplate, tokenValues);
        File wssClientConfigFile = Util.writeTextToTempFile(wssClientConfig, WSS_CLIENT_CONFIG_PREFIX, ".xml", retainTempFiles);
        pendingLogFine.append("Temporary wss-client-config.xml file: " + wssClientConfigFile.getAbsolutePath() + lineSep);
        String quotedConfigFileSpec = wssClientConfigFile.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
        tokenValues.setProperty(SUN_ACC_SECURITY_CONFIG_PROPERTY, quotedConfigFileSpec);
        String sunaccContent = Util.replaceTokens(sunACCTemplate, tokenValues);
        File sunaccFile = Util.writeTextToTempFile(sunaccContent, SUN_ACC_PREFIX, ".xml", retainTempFiles);
        pendingLogFine.append("Temporary sun-acc.xml file: " + sunaccFile.getAbsolutePath());
        return sunaccFile.getAbsolutePath();
    }

    private void prepareJWSLoginConfig() throws IOException, FileNotFoundException {
        this.prepareJWSDefaultLoginConfig();
    }

    private void prepareJWSDefaultLoginConfig() throws IOException, FileNotFoundException {
        String configContent = Util.loadResource(this.getClass(), LOGIN_CONF_TEMPLATE);
        File configFile = Util.writeTextToTempFile(configContent, LOGIN_CONF_FILE_PREFIX, LOGIN_CONF_FILE_SUFFIX, retainTempFiles);
        String configFilePath = configFile.getAbsolutePath();
        pendingLogFine.append("Temporary appclientlogin.conf file: " + configFilePath);
        System.setProperty(LOGIN_CONF_PROPERTY_NAME, configFilePath);
    }

    private File findAppClientFileForJWSLaunch() throws ClassNotFoundException, URISyntaxException {
        String probeClassName = System.getProperty(APPCLIENT_PROBE_CLASSNAME_PROPERTYNAME);
        _logger.fine("Probing class " + probeClassName);
        Class<?> probeClass = Class.forName(probeClassName);
        URL workingURL = probeClass.getProtectionDomain().getCodeSource().getLocation();
        _logger.fine("Location of appclient jar file: " + workingURL.toString());
        URI workingURI = workingURL.toURI();
        String ssp = workingURI.getSchemeSpecificPart();
        return new File(ssp);
    }

    static {
        localStrings = StringManager.getManager(Main.class);
        runClient = true;
        pendingLogInfo = new StringBuilder();
        pendingLogFine = new StringBuilder();
        retainTempFiles = false;
        supportModuleFormatValue = System.getProperty(SUPPORT_MODULE_FORMAT, SUPPORT_MODULE_FORMAT_DEFAULT_VALUE);
        supportModuleFormat = Boolean.parseBoolean(supportModuleFormatValue);
        lb_enabled = false;
    }

    private static class Cleanup
    extends Thread {
        private AppContainer appContainer = null;
        private boolean cleanedUp = false;

        public void setAppContainer(AppContainer container) {
            this.appContainer = container;
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUp() {
            if (!this.cleanedUp) {
                try {
                    block5: {
                        try {
                            if (this.appContainer == null) break block5;
                            this.appContainer.postInvoke();
                        }
                        catch (Throwable throwable) {
                            Object var3_2 = null;
                            this.cleanedUp = true;
                        }
                    }
                    Object var3_1 = null;
                    this.cleanedUp = true;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.cleanedUp = true;
                    throw throwable;
                }
            }
        }
    }
}

