/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class LifecycleModuleTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Object value = ccce.getObject();
        Result result = new Result();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        LifecycleModule life = (LifecycleModule)value;
        String id = life.getName();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("LifeCycle Module Name Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        String loadOrder = life.getLoadOrder();
        try {
            if (loadOrder != null && Integer.parseInt(loadOrder) < 0) {
                result.failed("Load Order Must be positive number");
                return result;
            }
            result.passed("Test passed ******");
        }
        catch (NumberFormatException e) {
            result.failed("Load Order for LifeCycleModule must be integer value");
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed(" ***");
        if (name.equals("load-order")) {
            try {
                if (value != null && Integer.parseInt(value) < 0) {
                    result.failed("Load Order Must be positive number");
                    return result;
                }
                result.passed("Test passed ******");
            }
            catch (NumberFormatException e) {
                result.failed("Load Order for LifeCycleModule must be integer value");
            }
        }
        return result;
    }
}

