/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;

public abstract class Target
implements Serializable {
    private static final StringManager strMgr = StringManager.getManager(Target.class);
    private final String name;
    private final transient ConfigContext cc;

    Target(String name, ConfigContext cc) {
        this.checkArg(name, strMgr.getString("target.name"));
        this.checkArg(cc, strMgr.getString("target.config_context"));
        this.name = name;
        this.cc = cc;
    }

    public String getName() {
        return this.name;
    }

    public abstract TargetType getType();

    public abstract String getConfigRef() throws ConfigException;

    public abstract ConfigTarget getConfigTarget() throws Exception;

    public abstract String getTargetObjectName(String[] var1);

    public abstract Server[] getServers() throws ConfigException;

    public abstract Cluster[] getClusters() throws ConfigException;

    public abstract Config[] getConfigs() throws ConfigException;

    public abstract NodeAgent[] getNodeAgents() throws ConfigException;

    public abstract ApplicationRef[] getApplicationRefs() throws ConfigException;

    public abstract ResourceRef[] getResourceRefs() throws ConfigException;

    protected ConfigContext getConfigContext() {
        return this.cc;
    }

    protected void checkArg(Object o, Object name) {
        if (null == o) {
            throw new IllegalArgumentException(strMgr.getString("target.cant_be_null", name.toString()));
        }
    }

    protected void checkTokens(String[] tokens, int minLen) {
        this.checkArg(tokens, this.name);
        if (tokens.length < minLen) {
            throw new IllegalArgumentException(strMgr.getString("target.min_token_length", "" + minLen));
        }
    }
}

