/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;

public class ManagedJVM
extends ConfigMBeanBase
implements ConfigAttributeName.JavaConfig {
    private static final String[][] MAPLIST = new String[][]{{"javahome", "@java-home"}, {"debugEnabled", "@debug-enabled"}, {"debugOptions", "@debug-options"}, {"rmicoptions", "@rmic-options"}, {"javacOptions", "@javac-options"}, {"classpathprefix", "@classpath-prefix"}, {"serverClasspath", "@server-classpath"}, {"classpathsuffix", "@classpath-suffix"}, {"libpathprefix", "@native-library-path-prefix"}, {"libpathsuffix", "@native-library-path-suffix"}, {"envpathignore", "@env-classpath-ignored"}};
    private static final String[] ATTRIBUTES = new String[]{"javahome,   String,  RW", "debugEnabled,   boolean, RW", "debugOptions,   String,  RW", "rmicoptions,   String,  RW", "javacOptions,   String,  RW", "classpathprefix,   String,  RW", "serverClasspath,   String,  RW", "classpathsuffix,   String,  RW", "libpathprefix,   String,  RW", "libpathsuffix,   String,  RW", "envpathignore,   boolean, RW"};
    private static final String[] OPERATIONS = new String[]{"createProfiler(String name, String classpath, String nativeLibraryPath, Boolean enabled), ACTION", "deleteProfiler(), ACTION", "isProfilerExist(), INFO", "getProfiler(), INFO", "getJvmOptions(), INFO", "setJvmOptions(String[] options), ACTION"};
    private final String JVM_NODE_PATH = "/server/java-config";

    public ManagedJVM() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedJVM(String instanceName) throws MBeanConfigException {
        this();
        this.initialize("java-config", new String[]{instanceName});
    }

    public void createProfiler(String name, String classpath, String nativeLibraryPath, Boolean enabled) throws ConfigException {
        Profiler element = new Profiler();
        if (name != null) {
            element.setName(name);
        }
        if (classpath != null) {
            element.setClasspath(classpath);
        }
        if (nativeLibraryPath != null) {
            element.setNativeLibraryPath(nativeLibraryPath);
        }
        if (enabled != null) {
            element.setEnabled(enabled);
        }
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setProfiler(element);
        this.getConfigContext().flush();
    }

    public void deleteProfiler() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setProfiler(null);
        this.getConfigContext().flush();
    }

    public boolean isProfilerExist() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        return javaConfig.getProfiler() != null;
    }

    public String getProfiler() throws ConfigException {
        String profilerName = null;
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        Profiler profiler = javaConfig.getProfiler();
        if (profiler != null) {
            profilerName = profiler.getName();
        }
        return profilerName;
    }

    public String[] getJvmOptions() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        return javaConfig.getJvmOptions();
    }

    public void setJvmOptions(String[] options) throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)this.getBaseConfigBean();
        javaConfig.setJvmOptions(options);
        this.getConfigContext().flush();
    }
}

