/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.server.core.jmx.Introspector;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public abstract class AdminBase
implements DynamicMBean {
    private static StringManager localStrings = StringManager.getManager(AdminBase.class);

    protected AdminBase() {
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented");
        throw new UnsupportedOperationException(msg);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented");
        throw new UnsupportedOperationException(msg);
    }

    public MBeanInfo getMBeanInfo() {
        String msg = localStrings.getString("admin.server.core.mbean.config.getmbeaninfo_not_implemented");
        throw new UnsupportedOperationException(msg);
    }

    protected abstract Class getImplementingClass();

    protected abstract Object getImplementingMBean();

    public Object invoke(String methodName, Object[] methodParams, String[] methodSignature) throws MBeanException, ReflectionException {
        Class implClass = this.getImplementingClass();
        Object mbeanReference = this.getImplementingMBean();
        Introspector reflector = new Introspector(implClass);
        Object value = null;
        try {
            Method method = reflector.getMethod(methodName, methodSignature);
            value = reflector.invokeMethodOn(method, mbeanReference, methodParams);
            return value;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            String msg = localStrings.getString("admin.server.core.jmx.error_from_mbean", t.getMessage());
            RuntimeException re = new RuntimeException(msg);
            throw new MBeanException(re);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_not_implemented");
        throw new UnsupportedOperationException(msg);
    }

    public AttributeList setAttributes(AttributeList parm1) {
        String msg = localStrings.getString("admin.server.core.mbean.config.setattributes_not_implemented");
        throw new UnsupportedOperationException(msg);
    }
}

