/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReconfigHelper {
    private static boolean reconfigEnabled = false;
    private static Class j2eeRunnerClass = null;
    private static Method reconfigMethod = null;
    private static final String J2EE_RUNNER_CLASS = "com.sun.enterprise.server.J2EERunner";
    private static final String RECONFIG_METHOD = "requestReconfiguration";
    private static final String RECONFIG_ERROR = "channel.reconfig_error";

    static void enableWebCoreReconfig() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        ReconfigHelper.findReconfigMethod();
        if (reconfigMethod != null) {
            reconfigEnabled = true;
        }
    }

    public static void sendReconfigMessage(String instanceName) {
        if (reconfigEnabled) {
            try {
                reconfigMethod.invoke(null, (Object[])null);
            }
            catch (IllegalAccessException access) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(access);
            }
            catch (IllegalArgumentException arg) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(arg);
            }
            catch (InvocationTargetException ite) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(ite.getTargetException());
                AdminChannel.debug(ite);
            }
        }
    }

    private static int reconfig(String instanceName) {
        int retval = 0;
        String[] cmd = ReconfigHelper.getReconfigCommand(instanceName);
        if (cmd != null) {
            ProcessExecutor pe = new ProcessExecutor(cmd);
            try {
                pe.execute();
            }
            catch (ExecException ee) {
                AdminChannel.debug(ee);
                retval = 1;
            }
        }
        return retval;
    }

    private static String[] getReconfigCommand(String instance) {
        String pfx = AdminChannel.instanceRoot + File.separator + instance + File.separator;
        if (OS.isUnix()) {
            return new String[]{pfx + "reconfig"};
        }
        if (OS.isWindows()) {
            return new String[]{pfx + "reconfig.bat"};
        }
        return null;
    }

    private static void findReconfigMethod() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        j2eeRunnerClass = Class.forName(J2EE_RUNNER_CLASS);
        reconfigMethod = j2eeRunnerClass.getMethod(RECONFIG_METHOD, null);
    }
}

