/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MBeanRegistryFactory {
    private static MBeanRegistry adminRegistry = null;
    private static MBeanRegistry runtimeRegistry = null;
    private static volatile AdminContext adminContext = null;
    protected static final Logger _sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public static void setAdminContext(AdminContext ctx) {
        adminContext = ctx;
    }

    public static AdminContext getAdminContext() {
        return adminContext;
    }

    public static synchronized void setAdminMBeanRegistry(MBeanRegistry registry) {
        adminRegistry = registry;
    }

    public static synchronized MBeanRegistry getAdminMBeanRegistry() {
        if (adminRegistry != null) {
            return adminRegistry;
        }
        try {
            if (adminContext != null && !ServerHelper.isDAS(adminContext.getRuntimeConfigContext(), adminContext.getServerName())) {
                adminRegistry = new MBeanRegistry();
                return adminRegistry;
            }
            URL url = null;
            if (adminContext != null) {
                url = adminContext.getAdminMBeanRegistryURL();
            }
            if (url == null) {
                url = MBeanRegistry.class.getResource("/admin-mbeans-descriptors.xml");
            }
            InputStream stream = url.openStream();
            adminRegistry = new MBeanRegistry();
            adminRegistry.loadMBeanRegistry(stream);
            stream.close();
            try {
                String fileName = System.getProperty("adminmbeanregistry.printfile");
                if (fileName != null) {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                    out.println("MBean REGISTRY (in XPath value order)");
                    adminRegistry.sortRegistryEntries(1);
                    out.print(adminRegistry.toFormatString());
                    out.println("\n\n\nMBean REGISTRY (in Type value order)");
                    adminRegistry.sortRegistryEntries(0);
                    out.print(adminRegistry.toFormatString());
                    out.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return adminRegistry;
        }
        catch (Throwable t) {
            _sLogger.log(Level.WARNING, "core.registryfactory_adminregistry_not_found", t);
            return null;
        }
    }

    public static synchronized MBeanRegistry getRuntimeMBeanRegistry() {
        if (runtimeRegistry != null) {
            return runtimeRegistry;
        }
        try {
            URL url = null;
            if (adminContext != null) {
                url = adminContext.getRuntimeMBeanRegistryURL();
            }
            if (url == null) {
                url = MBeanRegistry.class.getResource("/runtime-mbeans-descriptors.xml");
            }
            InputStream stream = url.openStream();
            runtimeRegistry = new MBeanRegistry();
            runtimeRegistry.loadMBeanRegistry(stream);
            stream.close();
            return runtimeRegistry;
        }
        catch (Throwable t) {
            _sLogger.log(Level.WARNING, "core.registryfactory_adminregistry_not_found", t);
            return null;
        }
    }

    public static MBeanRegistry getMBeanRegistry(String fileName) {
        return MBeanRegistryFactory.getMBeanRegistry(fileName, true);
    }

    public static synchronized MBeanRegistry getMBeanRegistry(String fileName, boolean bIntrospectMBeans) {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            MBeanRegistry myRegistry = new MBeanRegistry();
            myRegistry.loadMBeanRegistry(stream, bIntrospectMBeans);
            stream.close();
            return myRegistry;
        }
        catch (Throwable t) {
            _sLogger.log(Level.WARNING, "core.registryfactory_registry_not_found", t);
            return null;
        }
    }

    public static synchronized MBeanRegistry getOfflineAdminMBeanRegistry() throws Exception {
        URL url = null;
        url = MBeanRegistry.class.getResource("/admin-mbeans-descriptors-ee.xml");
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stream == null) {
            url = MBeanRegistry.class.getResource("/admin-mbeans-descriptors.xml");
            stream = url.openStream();
        }
        if (stream == null) {
            return null;
        }
        MBeanRegistry myRegistry = new MBeanRegistry();
        myRegistry.loadMBeanRegistry(stream, false);
        stream.close();
        return myRegistry;
    }
}

