/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.util;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBServerConfigLookup {
    protected final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    protected final String DEFAULT_SFSB_HA_PERSISTENCE_TYPE = "file";
    protected final String DEFAULT_SFSB_NON_HA_PERSISTENCE_TYPE = "file";
    private static final String REPLICATED_TYPE = "replicated";
    protected EjbDescriptor _ejbDescriptor = null;
    protected boolean _haEnabled = false;
    protected ConfigContext _configContext = null;
    protected static boolean _isDebugMonitoringEnabled = false;
    private static final Logger _logger;

    public EJBServerConfigLookup() {
    }

    public EJBServerConfigLookup(EjbDescriptor ejbDescriptor) {
        this();
        this._ejbDescriptor = ejbDescriptor;
    }

    public EJBServerConfigLookup(EjbDescriptor ejbDescriptor, ConfigContext configContext) {
        this(ejbDescriptor);
        this._configContext = configContext;
    }

    public static boolean isMonitoringEnabled() {
        return EJBServerConfigLookup.isDebugMonitoringEnabled();
    }

    public static boolean isDebugMonitoringEnabled() {
        return _isDebugMonitoringEnabled;
    }

    public boolean getAvailabilityEnabledFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromConfig");
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            _logger.fine("AvailabilityService was not defined - check domain.xml");
            return false;
        }
        return as.isAvailabilityEnabled();
    }

    protected AvailabilityService getAvailabilityService() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        return configBean.getAvailabilityService();
    }

    protected ServerContext getServerContext() {
        return ApplicationServer.getServerContext();
    }

    protected ConfigContext getConfigContext() {
        ServerContext serverCtx = this.getServerContext();
        if (serverCtx == null) {
            return null;
        }
        return serverCtx.getConfigContext();
    }

    protected ConfigContext getConfigContextDynamic() {
        if (this._configContext != null) {
            return this._configContext;
        }
        return this.getConfigContext();
    }

    private Config getConfigBean() {
        Config configBean = null;
        ServerContext serverCtx = ApplicationServer.getServerContext();
        ConfigContext configCtx = serverCtx.getConfigContext();
        try {
            configBean = ServerBeansFactory.getConfigBean(configCtx);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return configBean;
    }

    private Applications getApplicationsBean() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Applications getApplicationsBeanDynamic() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContextDynamic();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Server getServerBean() {
        Server serverBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            serverBean = ServerBeansFactory.getServerBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return serverBean;
    }

    private String getServerName() {
        String result = null;
        Server serverBean = this.getServerBean();
        if (serverBean != null) {
            result = serverBean.getName();
        }
        return result;
    }

    public String getClusterName() {
        String result = null;
        ConfigContext configCtx = this.getConfigContext();
        String serverName = this.getServerName();
        if (serverName == null) {
            return result;
        }
        boolean isClustered = false;
        try {
            isClustered = ServerHelper.isServerClustered(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (!isClustered) {
            result = serverName + "_nc";
            return result;
        }
        Cluster cluster = null;
        try {
            cluster = ClusterHelper.getClusterForInstance(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (cluster != null) {
            result = cluster.getName();
        }
        return result;
    }

    public boolean calculateEjbAvailabilityEnabledFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>calculateEjbAvailabilityEnabledFromConfig");
        boolean isVirtual = this.isVirtualApplication();
        String appName = this.getApplicationName();
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        boolean ejbContainerAvailability = this.getEjbContainerAvailabilityEnabledFromConfig(globalAvailability);
        boolean ejbDescriptorAvailability = true;
        if (isVirtual) {
            boolean ejbModuleAvailability = this.getEjbModuleAvailability(appName, ejbContainerAvailability);
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor(ejbModuleAvailability);
            this._haEnabled = globalAvailability && ejbContainerAvailability && ejbModuleAvailability && ejbDescriptorAvailability;
        } else {
            boolean j2eeApplicationAvailability = this.getJ2eeApplicationAvailability(appName, ejbContainerAvailability);
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor(j2eeApplicationAvailability);
            this._haEnabled = globalAvailability && ejbContainerAvailability && j2eeApplicationAvailability && ejbDescriptorAvailability;
        }
        return this._haEnabled;
    }

    public String getPersistenceStoreType() {
        return this._haEnabled ? this.getSfsbHaPersistenceTypeFromConfig() : this.getSfsbNonHaPersistenceTypeFromConfig();
    }

    private boolean isVirtualApplication() {
        Application application = this._ejbDescriptor.getApplication();
        return application.isVirtual();
    }

    private String getApplicationName() {
        Application application = this._ejbDescriptor.getApplication();
        return application.getRegistrationName();
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return globalAvailabilityEnabled;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return inheritedValue;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    private EjbModule getEjbModuleByName(String name) {
        Object result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        return applicationsBean.getEjbModuleByName(name);
    }

    private boolean getEjbModuleAvailability(String name, boolean inheritedValue) {
        EjbModule ejbModule = this.getEjbModuleByName(name);
        if (ejbModule == null) {
            return false;
        }
        return ejbModule.isAvailabilityEnabled();
    }

    private J2eeApplication getJ2eeApplicationByName(String appName) {
        Object result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        return applicationsBean.getJ2eeApplicationByName(appName);
    }

    private boolean getJ2eeApplicationAvailability(String appName, boolean inheritedValue) {
        J2eeApplication j2eeApp = this.getJ2eeApplicationByName(appName);
        if (j2eeApp == null) {
            return false;
        }
        return j2eeApp.isAvailabilityEnabled();
    }

    private EjbContainerAvailability getEjbContainerAvailability() {
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean == null) {
            return null;
        }
        return availabilityServiceBean.getEjbContainerAvailability();
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor() {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return true;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return inheritedValue;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    public String getStorePoolJndiNameFromConfig() {
        _logger.finest("in ServerConfigLookup>>getStorePoolJndiNameFromConfig");
        String result = "jdbc/hastore";
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return result;
        }
        String storePoolJndiName = as.getStorePoolName();
        if (storePoolJndiName != null) {
            result = storePoolJndiName;
        }
        return result;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getHaStorePoolJndiNameFromConfig");
        String result = this.getStorePoolJndiNameFromConfig();
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbStorePoolName();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbHaPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbNonHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbNonHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public static boolean checkDebugMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_EJB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isReplicationTypeMemory() {
        return REPLICATED_TYPE.equalsIgnoreCase(this.getSfsbHaPersistenceTypeFromConfig());
    }

    public static final boolean needToAddSFSBVersionInterceptors() {
        boolean isClustered = false;
        boolean isEJBAvailabilityEnabled = false;
        boolean isStoreTypeMemory = false;
        try {
            EJBServerConfigLookup ejbSCLookup = new EJBServerConfigLookup();
            ConfigContext configCtx = ejbSCLookup.getConfigContext();
            isEJBAvailabilityEnabled = ejbSCLookup.getEjbContainerAvailabilityEnabledFromConfig();
            _logger.log(Level.INFO, "EJBSCLookup:: sc.getEjbContainerAvailabilityEnabledFromConfig() ==> " + isEJBAvailabilityEnabled);
            try {
                isClustered = ServerHelper.isServerClustered(configCtx, ejbSCLookup.getServerContext().getInstanceName());
            }
            catch (ConfigException conFigEx) {
                _logger.log(Level.INFO, "Got ConfigException. Will assume isClustered to be false", conFigEx);
                isClustered = false;
            }
            isStoreTypeMemory = ejbSCLookup.isReplicationTypeMemory();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Got exception in needToAddSFSBVersionInterceptors (" + ex + "). SFSBVersionInterceptors not added");
            _logger.log(Level.FINE, "Exception in needToAddSFSBVersionInterceptors", ex);
        }
        boolean result = isClustered && isEJBAvailabilityEnabled && isStoreTypeMemory;
        _logger.log(Level.FINE, "EJBServerConfigLookup::==> isClustered:" + isClustered + " ; isEJBAvailabilityEnabled: " + isEJBAvailabilityEnabled + " ; isStoreTypeMemory ==> " + isStoreTypeMemory + " ; result: " + result);
        return result;
    }

    static {
        _isDebugMonitoringEnabled = EJBServerConfigLookup.checkDebugMonitoringEnabled();
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

