/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaClientRequestDispatcherImpl;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.LocalObject;

public class NoConnectionCacheImpl
extends LocalObject
implements ORBConfigurator {
    private static ThreadLocal connectionCache = new ThreadLocal();

    private static NCCConnectionCacheImpl getConnectionCache(ORB orb) {
        NCCConnectionCacheImpl result = (NCCConnectionCacheImpl)connectionCache.get();
        if (result == null) {
            result = new NCCConnectionCacheImpl(orb);
            connectionCache.set(result);
        }
        return result;
    }

    public void configure(DataCollector dc, final ORB orb) {
        CorbaContactInfoListFactory factory = new CorbaContactInfoListFactory(){

            public void setORB(ORB orb2) {
            }

            public CorbaContactInfoList create(IOR ior) {
                return new NCCContactInfoListImpl(orb, ior);
            }
        };
        orb.getORBData().alwaysEnterBlockingRead(false);
        orb.setCorbaContactInfoListFactory(factory);
        NCCClientRequestDispatcherImpl crd = new NCCClientRequestDispatcherImpl();
        RequestDispatcherRegistry rdr = orb.getRequestDispatcherRegistry();
        for (int ctr = 0; ctr < 63; ++ctr) {
            ClientRequestDispatcher disp = rdr.getClientRequestDispatcher(ctr);
            if (disp == null) continue;
            rdr.registerClientRequestDispatcher(crd, ctr);
        }
    }

    private static class NCCClientRequestDispatcherImpl
    extends CorbaClientRequestDispatcherImpl {
        private NCCClientRequestDispatcherImpl() {
        }

        public void endRequest(Broker broker, Object self, InputObject inputObject) {
            super.endRequest(broker, self, inputObject);
            NoConnectionCacheImpl.getConnectionCache((ORB)broker).remove(null);
        }
    }

    private static class NCCConnectionCacheImpl
    extends CorbaConnectionCacheBase
    implements OutboundConnectionCache {
        private Map store = new HashMap();
        private boolean debug;
        private Connection connection = null;

        public void dprint(String msg) {
            ORBUtility.dprint("NCCConnectionCacheImpl", msg);
        }

        public NCCConnectionCacheImpl(ORB orb) {
            super(orb, "Dummy", "Dummy");
            this.debug = orb.transportDebugFlag;
        }

        public Collection values() {
            return this.store.values();
        }

        protected Object backingStore() {
            return this.store;
        }

        protected void registerWithMonitoring() {
        }

        public Connection get(ContactInfo contactInfo) {
            return this.connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ContactInfo contactInfo, Connection conn) {
            if (this.debug) {
                this.dprint("put-> " + conn);
            }
            try {
                this.remove(contactInfo);
                this.connection = conn;
            }
            finally {
                if (this.debug) {
                    this.dprint("put<-");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ContactInfo contactInfo) {
            if (this.debug) {
                this.dprint("remove->");
            }
            try {
                if (this.connection != null) {
                    if (this.debug) {
                        this.dprint("remove: closing connection " + this.connection);
                    }
                    this.connection.close();
                    this.connection = null;
                } else if (this.debug) {
                    this.dprint("remove: connection is null");
                }
            }
            finally {
                if (this.debug) {
                    this.dprint("remove<-");
                }
            }
        }
    }

    private static class NCCConnectionImpl
    extends SocketOrChannelConnectionImpl {
        private static int count = 0;
        private int myCount = count++;
        private boolean debug;

        public void dprint(String msg) {
            ORBUtility.dprint("NCCConnectionImpl", msg);
        }

        public NCCConnectionImpl(ORB orb, CorbaContactInfo contactInfo, String socketType, String hostname, int port) {
            super(orb, contactInfo, socketType, hostname, port);
            if (this.debug) {
                this.dprint("constructed new NCCConnectionImpl: " + this.toString());
            }
        }

        public String toString() {
            return "NCCConnectionImpl(" + this.myCount + ")[" + super.toString() + "]";
        }

        public synchronized void close() {
            if (this.debug) {
                this.dprint("close->: " + this);
            }
            super.closeConnectionResources();
            if (this.debug) {
                this.dprint("close<-: " + this);
            }
        }
    }

    private static class NCCContactInfoImpl
    extends SocketOrChannelContactInfoImpl {
        private boolean debug;

        public void dprint(String msg) {
            ORBUtility.dprint("NCCContactInfoImpl", msg);
        }

        public NCCContactInfoImpl(ORB orb, CorbaContactInfoList contactInfoList, IOR effectiveTargetIOR, short addressingDisposition, String socketType, String hostname, int port) {
            super(orb, contactInfoList, effectiveTargetIOR, addressingDisposition, socketType, hostname, port);
            this.debug = orb.transportDebugFlag;
        }

        public boolean shouldCacheConnection() {
            if (this.debug) {
                this.dprint("shouldCacheConnection : returns false");
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection createConnection() {
            if (this.debug) {
                this.dprint("createConnection->");
            }
            try {
                NCCConnectionImpl connection = new NCCConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
                if (this.debug) {
                    this.dprint("createConnection: created " + connection);
                }
                NCCConnectionCacheImpl cc = NoConnectionCacheImpl.getConnectionCache(this.orb);
                cc.put(this, connection);
                connection.setConnectionCache(cc);
                NCCConnectionImpl nCCConnectionImpl = connection;
                return nCCConnectionImpl;
            }
            finally {
                if (this.debug) {
                    this.dprint("createConnection<-");
                }
            }
        }
    }

    public static class NCCContactInfoListImpl
    extends CorbaContactInfoListImpl {
        public NCCContactInfoListImpl(ORB orb, IOR ior) {
            super(orb, ior);
        }

        public CorbaContactInfo createContactInfo(String type, String hostname, int port) {
            return new NCCContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
        }
    }
}

