/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.transport;

import com.sun.corba.ee.impl.orbutil.transport.ConnectionCacheBase;
import com.sun.corba.ee.spi.orbutil.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.orbutil.transport.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionCacheNonBlockingBase<C extends Connection>
extends ConnectionCacheBase<C> {
    protected final AtomicInteger totalBusy = new AtomicInteger();
    protected final AtomicInteger totalIdle = new AtomicInteger();

    ConnectionCacheNonBlockingBase(String cacheType, int highWaterMark, int numberToReclaim, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        this.reclaimableConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue();
    }

    @Override
    public long numberOfConnections() {
        return this.totalIdle.get() + this.totalBusy.get();
    }

    @Override
    public long numberOfIdleConnections() {
        return this.totalIdle.get();
    }

    @Override
    public long numberOfBusyConnections() {
        return this.totalBusy.get();
    }

    @Override
    public long numberOfReclaimableConnections() {
        return this.reclaimableConnections.size();
    }
}

