/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.copyobject;

import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopier;
import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopierBase;
import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopierFactory;
import com.sun.corba.ee.spi.orbutil.copyobject.ReflectiveCopyException;
import java.lang.reflect.Array;
import java.util.Map;

public class ClassCopierFactoryArrayImpl
implements ClassCopierFactory {
    private final ClassCopierFactory classCopierFactory;
    private ClassCopier arrayClassCopier = new ClassCopierBase("array"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            int alen = Array.getLength(source);
            Object result = Array.newInstance(source.getClass().getComponentType(), alen);
            return result;
        }

        public Object doCopy(Map oldToNew, Object source, Object result, boolean debug) throws ReflectiveCopyException {
            int alen = Array.getLength(source);
            for (int ctr = 0; ctr < alen; ++ctr) {
                Object aobj = Array.get(source, ctr);
                if (aobj != null) {
                    ClassCopier copier = ClassCopierFactoryArrayImpl.this.classCopierFactory.getClassCopier(aobj.getClass());
                    aobj = copier.copy(oldToNew, aobj);
                }
                Array.set(result, ctr, aobj);
            }
            return result;
        }
    };
    private static ClassCopier booleanArrayClassCopier = new ClassCopierBase("boolean"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            boolean[] obj = (boolean[])source;
            return obj.clone();
        }
    };
    private static ClassCopier byteArrayClassCopier = new ClassCopierBase("byte"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            byte[] obj = (byte[])source;
            return obj.clone();
        }
    };
    private static ClassCopier charArrayClassCopier = new ClassCopierBase("char"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            char[] obj = (char[])source;
            return obj.clone();
        }
    };
    private static ClassCopier shortArrayClassCopier = new ClassCopierBase("short"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            short[] obj = (short[])source;
            return obj.clone();
        }
    };
    private static ClassCopier intArrayClassCopier = new ClassCopierBase("int"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            int[] obj = (int[])source;
            return obj.clone();
        }
    };
    private static ClassCopier longArrayClassCopier = new ClassCopierBase("long"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            long[] obj = (long[])source;
            return obj.clone();
        }
    };
    private static ClassCopier floatArrayClassCopier = new ClassCopierBase("float"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            float[] obj = (float[])source;
            return obj.clone();
        }
    };
    private static ClassCopier doubleArrayClassCopier = new ClassCopierBase("double"){

        public Object createCopy(Object source, boolean debug) throws ReflectiveCopyException {
            double[] obj = (double[])source;
            return obj.clone();
        }
    };

    public ClassCopierFactoryArrayImpl(ClassCopierFactory ccf) {
        this.classCopierFactory = ccf;
    }

    public ClassCopier getClassCopier(Class cls) {
        Class<?> compType = cls.getComponentType();
        if (compType == null) {
            return null;
        }
        if (compType.isPrimitive()) {
            if (compType == Boolean.TYPE) {
                return booleanArrayClassCopier;
            }
            if (compType == Byte.TYPE) {
                return byteArrayClassCopier;
            }
            if (compType == Character.TYPE) {
                return charArrayClassCopier;
            }
            if (compType == Short.TYPE) {
                return shortArrayClassCopier;
            }
            if (compType == Integer.TYPE) {
                return intArrayClassCopier;
            }
            if (compType == Long.TYPE) {
                return longArrayClassCopier;
            }
            if (compType == Float.TYPE) {
                return floatArrayClassCopier;
            }
            if (compType == Double.TYPE) {
                return doubleArrayClassCopier;
            }
            return null;
        }
        return this.arrayClassCopier;
    }
}

