/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.dynamicany;

import com.sun.corba.ee.impl.dynamicany.DynAnyCollectionImpl;
import com.sun.corba.ee.impl.dynamicany.DynAnyImpl;
import com.sun.corba.ee.impl.dynamicany.DynAnyUtil;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynSequence;

public class DynSequenceImpl
extends DynAnyCollectionImpl
implements DynSequence {
    private DynSequenceImpl() {
        this(null, null, false);
    }

    protected DynSequenceImpl(ORB orb, Any any, boolean copyValue) {
        super(orb, any, copyValue);
    }

    protected DynSequenceImpl(ORB orb, TypeCode typeCode) {
        super(orb, typeCode);
    }

    protected boolean initializeComponentsFromAny() {
        InputStream input;
        TypeCode typeCode = this.any.type();
        TypeCode contentType = this.getContentType();
        try {
            input = this.any.create_input_stream();
        }
        catch (BAD_OPERATION e) {
            return false;
        }
        int length = input.read_long();
        this.components = new DynAny[length];
        this.anys = new Any[length];
        for (int i = 0; i < length; ++i) {
            this.anys[i] = DynAnyUtil.extractAnyFromStream(contentType, input, this.orb);
            try {
                this.components[i] = DynAnyUtil.createMostDerivedDynAny(this.anys[i], this.orb, false);
                continue;
            }
            catch (InconsistentTypeCode itc) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean initializeComponentsFromTypeCode() {
        this.components = new DynAny[0];
        this.anys = new Any[0];
        return true;
    }

    protected boolean initializeAnyFromComponents() {
        OutputStream out = this.any.create_output_stream();
        out.write_long(this.components.length);
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] instanceof DynAnyImpl) {
                ((DynAnyImpl)this.components[i]).writeAny(out);
                continue;
            }
            this.components[i].to_any().write_value(out);
        }
        this.any.read_value(out.create_input_stream(), this.any.type());
        return true;
    }

    public int get_length() {
        if (this.status == 2) {
            throw this.wrapper.dynAnyDestroyed();
        }
        return this.checkInitComponents() ? this.components.length : 0;
    }

    public void set_length(int len) throws InvalidValue {
        if (this.status == 2) {
            throw this.wrapper.dynAnyDestroyed();
        }
        int bound = this.getBound();
        if (bound > 0 && len > bound) {
            throw new InvalidValue();
        }
        this.checkInitComponents();
        int oldLength = this.components.length;
        if (len > oldLength) {
            DynAny[] newComponents = new DynAny[len];
            Any[] newAnys = new Any[len];
            System.arraycopy(this.components, 0, newComponents, 0, oldLength);
            System.arraycopy(this.anys, 0, newAnys, 0, oldLength);
            this.components = newComponents;
            this.anys = newAnys;
            TypeCode contentType = this.getContentType();
            for (int i = oldLength; i < len; ++i) {
                this.createDefaultComponentAt(i, contentType);
            }
            if (this.index == -1) {
                this.index = oldLength;
            }
        } else if (len < oldLength) {
            DynAny[] newComponents = new DynAny[len];
            Any[] newAnys = new Any[len];
            System.arraycopy(this.components, 0, newComponents, 0, len);
            System.arraycopy(this.anys, 0, newAnys, 0, len);
            this.components = newComponents;
            this.anys = newAnys;
            if (len == 0 || this.index >= len) {
                this.index = -1;
            }
        } else if (this.index == -1 && len > 0) {
            this.index = 0;
        }
    }

    protected void checkValue(Object[] value) throws InvalidValue {
        if (value == null || value.length == 0) {
            this.clearData();
            this.index = -1;
            return;
        }
        this.index = 0;
        int bound = this.getBound();
        if (bound > 0 && value.length > bound) {
            throw new InvalidValue();
        }
    }
}

