/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final transient int UNICODESTREAM = 273;
    static final transient int BINARYSTREAM = 546;
    static final transient int ASCIISTREAM = 819;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;

    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = rowSetInternal.getConnection();
        if (connection != null && !connection.isClosed()) {
            return connection;
        }
        if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                Object object;
                InitialContext initialContext = null;
                try {
                    object = System.getProperties();
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                }
                catch (SecurityException securityException) {}
                if (initialContext == null) {
                    initialContext = new InitialContext();
                }
                object = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                return object.getConnection(((RowSet)((Object)rowSetInternal)).getUsername(), ((RowSet)((Object)rowSetInternal)).getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        }
        if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = ((RowSet)((Object)rowSetInternal)).getUrl();
            String string2 = ((RowSet)((Object)rowSetInternal)).getUsername();
            String string3 = ((RowSet)((Object)rowSetInternal)).getPassword();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        return null;
    }

    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        Connection connection = this.getConnection(rowSetInternal);
        if (connection == null || oracleCachedRowSet.getCommand() == null) {
            throw new SQLException("Sorry, Could not obtain connection");
        }
        try {
            connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {}
        PreparedStatement preparedStatement = connection.prepareStatement(oracleCachedRowSet.getCommand());
        this.setParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(oracleCachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(oracleCachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(oracleCachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(oracleCachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {}
        ResultSet resultSet = preparedStatement.executeQuery();
        oracleCachedRowSet.populate(resultSet);
        resultSet.close();
        preparedStatement.close();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {}
        connection.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        while (n < objectArray.length) {
            block21: {
                int n2 = 0;
                try {
                    n2 = Array.getLength(objectArray[n]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    break block21;
                }
                Object[] objectArray2 = (Object[])objectArray[n];
                if (n2 == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        if (!(objectArray2[1] instanceof Calendar)) throw new SQLException("Unable to deduce param type");
                        preparedStatement.setDate(n + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(n + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                    } else if (objectArray2[1] instanceof Integer) {
                        preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1]);
                    }
                } else if (n2 == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                    } else if (objectArray2[0] instanceof InputStream) {
                        switch ((Integer)objectArray2[2]) {
                            case 273: {
                                preparedStatement.setUnicodeStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 546: {
                                preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 819: {
                                preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                        }
                        throw new SQLException("Unable to deduce parameter type");
                    }
                    if (!(objectArray2[1] instanceof Integer) || !(objectArray2[2] instanceof Integer)) throw new SQLException("Unable to deduce param type");
                    preparedStatement.setObject(n + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                }
            }
            ++n;
        }
    }
}

