/*
 * Decompiled with CFR 0.152.
 */
package test.functional.mrp;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.I_PP_MRP;
import org.eevolution.model.I_PP_Product_Planning;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.process.MRP;
import test.functional.mrp.MRPNotice;
import test.functional.mrp.MRPUtil;

class TestableMRP
extends MRP {
    public String name = "junit-test";
    public String description = "";
    public String trxName = null;
    public String productValue = "junit-test";
    public I_PP_Product_Planning planning;
    public Timestamp today;
    public BigDecimal qtyOnHand;
    public List<I_PP_MRP> initialMRP = new ArrayList<I_PP_MRP>();
    public List<I_PP_MRP> expectedMRP = new ArrayList<I_PP_MRP>();
    public List<I_PP_MRP> actualMRP = new ArrayList<I_PP_MRP>();
    public List<MRPNotice> expectedNotices = new ArrayList<MRPNotice>();
    public List<MRPNotice> actualNotices = new ArrayList<MRPNotice>();
    public static final String[] ignoredMRPNotices = new String[]{"MRP-120", "MRP-130"};

    public static boolean isTestableMRPNotice(String code) {
        String[] stringArray = ignoredMRPNotices;
        int n = ignoredMRPNotices.length;
        int n2 = 0;
        while (n2 < n) {
            String notice = stringArray[n2];
            if (notice.equals(code)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Properties getCtx() {
        return Env.getCtx();
    }

    public String get_TrxName() {
        return this.trxName;
    }

    protected int getAD_Client_ID() {
        return this.planning.getAD_Client_ID();
    }

    @Override
    public int getAD_Org_ID() {
        return this.planning.getAD_Org_ID();
    }

    @Override
    public int getM_Warehouse_ID() {
        return this.planning.getM_Warehouse_ID();
    }

    @Override
    public int getPlant_ID() {
        return this.planning.getS_Resource_ID();
    }

    @Override
    public boolean isRequiredDRP() {
        return this.planning.isRequiredDRP();
    }

    @Override
    protected MPPProductPlanning getProductPlanning(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID, MProduct product) {
        return (MPPProductPlanning)this.planning;
    }

    @Override
    protected BigDecimal getQtyOnHand(I_PP_Product_Planning pp) {
        return this.qtyOnHand;
    }

    @Override
    protected Timestamp getToday() {
        return this.today;
    }

    @Override
    protected void createMRPNote(String code, int AD_Org_ID, int PP_MRP_ID, MProduct product, String documentNo, BigDecimal qty, String comment) {
        MRPNotice note = new MRPNotice(code);
        note.AD_Org_ID = AD_Org_ID;
        note.PP_MRP_ID = PP_MRP_ID;
        note.product = product;
        note.documentNo = documentNo;
        note.qty = qty;
        note.comment = comment;
        this.actualNotices.add(note);
    }

    @Override
    protected void createDDOrder(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule) {
        this.createMRPSupply(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule);
    }

    @Override
    protected void createPPOrder(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule) {
        this.createMRPSupply(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule);
    }

    @Override
    protected void createRequisition(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule) {
        this.createMRPSupply(AD_Org_ID, PP_MRP_ID, product, QtyPlanned, DemandDateStartSchedule);
    }

    private void createMRPSupply(int AD_Org_ID, int PP_MRP_ID, MProduct product, BigDecimal QtyPlanned, Timestamp DemandDateStartSchedule) {
        Timestamp datePromised = DemandDateStartSchedule;
        Timestamp dateStartSchedule = TimeUtil.addDays((Timestamp)datePromised, (int)(0 - this.planning.getDeliveryTime_Promised().intValueExact()));
        I_PP_MRP mrp = MRPUtil.createMRP(this.planning, "S", "DR", QtyPlanned, datePromised, dateStartSchedule);
        ((PO)mrp).saveEx(this.get_TrxName());
        this.actualMRP.add(mrp);
    }

    @Override
    public String doIt() throws Exception {
        this.p_M_Product_ID = this.planning.getM_Product_ID();
        for (I_PP_MRP mrp : this.initialMRP) {
            ((PO)mrp).saveEx(this.get_TrxName());
        }
        return super.doIt();
    }

    @Override
    protected void deleteMRP(int AD_Client_ID, int AD_Org_ID, int S_Resource_ID, int M_Warehouse_ID) throws SQLException {
        String sql = "DELETE FROM PP_MRP WHERE AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=? AND S_Resource_ID=? AND M_Product_ID=?";
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{AD_Client_ID, AD_Org_ID, M_Warehouse_ID, S_Resource_ID, this.p_M_Product_ID}, (String)this.get_TrxName());
        this.log.info("[DEBUG] clean up MRP #" + no);
        super.deleteMRP(AD_Client_ID, AD_Org_ID, S_Resource_ID, M_Warehouse_ID);
    }

    public void dumpStatus() {
        this.log.info("------------ MRP TEST --------------");
        this.log.info("          Name : " + this.name);
        this.log.info("   Description : " + this.description);
        this.log.info("       Product : " + this.productValue);
        this.log.info("         Today : " + this.today);
        this.log.info("     QtyOnHand : " + this.qtyOnHand);
        ((PO)this.planning).dump();
        this.log.info("------------ Initial MRP --------------");
        for (I_PP_MRP mrp : this.initialMRP) {
            this.log.info("    " + ((PO)mrp).toString());
        }
        this.log.info("------------ Expected MRP --------------");
        for (I_PP_MRP mrp : this.expectedMRP) {
            this.log.info("    " + ((PO)mrp).toString());
        }
        this.log.info("------------ Actual MRP --------------");
        for (I_PP_MRP mrp : this.actualMRP) {
            this.log.info(("    " + (PO)mrp).toString());
        }
        this.log.info("------------ Expected NOTICES --------------");
        for (MRPNotice notice : this.expectedNotices) {
            this.log.info("    " + notice.toString());
        }
        this.log.info("------------ Actual NOTICES --------------");
        for (MRPNotice notice : this.actualNotices) {
            this.log.info("    " + notice.toString());
        }
    }
}

