/*
 * Decompiled with CFR 0.152.
 */
package test.functional.mrp;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eevolution.model.I_PP_MRP;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;
import test.functional.mrp.MRPNotice;
import test.functional.mrp.MRPUtil;
import test.functional.mrp.TestableMRP;

public class CSVFactory {
    public static final DateFormat s_dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private ICsvListReader reader;

    public Collection<TestableMRP> read(InputStream in) throws Exception {
        ArrayList<TestableMRP> tests = new ArrayList<TestableMRP>();
        this.reader = new CsvListReader((Reader)new InputStreamReader(in), CsvPreference.STANDARD_PREFERENCE);
        Object[] header = this.reader.getCSVHeader(true);
        System.out.println("HEADER: " + MRPUtil.toString(header));
        int last_lineNo = -1;
        boolean isPlanningLine = true;
        TestableMRP mrpTest = null;
        try {
            List line;
            while ((line = this.reader.read()) != null) {
                if (last_lineNo == -1 || last_lineNo + 1 < this.reader.getLineNumber()) {
                    isPlanningLine = true;
                    if (mrpTest != null) {
                        tests.add(mrpTest);
                    }
                    mrpTest = new TestableMRP();
                }
                if (isPlanningLine) {
                    this.readProductPlanning(mrpTest, (String[])header, line);
                    isPlanningLine = false;
                } else {
                    this.readMRPLine(mrpTest, (String[])header, line);
                }
                last_lineNo = this.reader.getLineNumber();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error on line " + this.reader.getLineNumber() + ": " + e.getLocalizedMessage(), e);
        }
        if (mrpTest != null) {
            tests.add(mrpTest);
        }
        return tests;
    }

    private void readProductPlanning(TestableMRP mrpTest, String[] header, List<String> line) {
        mrpTest.name = "junit-test-line_" + this.reader.getLineNumber();
        mrpTest.description = "Test starts in CSV at line " + this.reader.getLineNumber();
        mrpTest.qtyOnHand = CSVFactory.getValue("QtyOnHand", BigDecimal.class, header, line);
        mrpTest.today = CSVFactory.getValue("Today", Timestamp.class, header, line);
        int LeadTime = CSVFactory.getValue("LeadTime", Integer.class, header, line);
        int TimeFence = CSVFactory.getValue("TimeFence", Integer.class, header, line);
        String Order_Policy = CSVFactory.getValue("Order_Policy", String.class, header, line);
        int Order_Min = CSVFactory.getValue("Order_Min", Integer.class, header, line);
        int Order_Pack = CSVFactory.getValue("Order_Pack", Integer.class, header, line);
        int Order_Max = CSVFactory.getValue("Order_Max", Integer.class, header, line);
        int Order_Period = CSVFactory.getValue("Order_Period", Integer.class, header, line);
        int SafetyStock = CSVFactory.getValue("SafetyStock", Integer.class, header, line);
        int Yield = CSVFactory.getValue("Yield", Integer.class, header, line);
        mrpTest.planning = MRPUtil.getPlanning(mrpTest.productValue, Order_Policy, Order_Min, Order_Max, Order_Pack, SafetyStock, Order_Period, LeadTime);
        mrpTest.planning.setTimeFence(BigDecimal.valueOf(TimeFence));
        mrpTest.planning.setYield(Yield);
    }

    private void readMRPLine(TestableMRP mrpTest, String[] header, List<String> line) {
        boolean isGenerated = CSVFactory.getValue("Generated", Boolean.class, header, line);
        Timestamp DatePromised = CSVFactory.getValue("DatePromised", Timestamp.class, header, line);
        Timestamp DateStartSchedule = CSVFactory.getValue("DateStartSchedule", Timestamp.class, header, line);
        String TypeMRP = CSVFactory.getValue("TypeMRP", String.class, header, line);
        String DocStatus = CSVFactory.getValue("DocStatus", String.class, header, line);
        BigDecimal Qty = CSVFactory.getValue("Qty", BigDecimal.class, header, line);
        String MRP_Notice = CSVFactory.getValue("MRP_Notice", String.class, header, line);
        if (MRP_Notice != null && MRP_Notice.trim().length() > 0 && TestableMRP.isTestableMRPNotice(MRP_Notice)) {
            mrpTest.expectedNotices.add(new MRPNotice(MRP_Notice));
        }
        if (TypeMRP != null && TypeMRP.trim().length() != 0) {
            I_PP_MRP mrp = MRPUtil.createMRP(mrpTest.planning, TypeMRP, DocStatus, Qty, DatePromised, DateStartSchedule);
            mrp.setDescription("CSV Line " + this.reader.getLineNumber());
            if (isGenerated) {
                mrpTest.expectedMRP.add(mrp);
            } else {
                mrpTest.initialMRP.add(mrp);
            }
        }
    }

    public static <T> T getValue(String name, Class<T> clazz, String[] headers, List<String> values) {
        String value = null;
        int i = 0;
        while (i < headers.length) {
            if (name.equalsIgnoreCase(headers[i])) {
                if (values.size() <= i) break;
                value = values.get(i);
                break;
            }
            ++i;
        }
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        if (String.class == clazz) {
            return (T)value;
        }
        if (BigDecimal.class == clazz) {
            if (value == null) {
                return (T)BigDecimal.ZERO;
            }
            return (T)new BigDecimal(value.replace(',', '.'));
        }
        if (Integer.class == clazz) {
            if (value == null) {
                return (T)Integer.valueOf(0);
            }
            return (T)Integer.valueOf(Integer.parseInt(value));
        }
        if (Timestamp.class == clazz) {
            if (value == null) {
                return null;
            }
            try {
                Date date = s_dateFormat.parse(value);
                return (T)new Timestamp(date.getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (Boolean.class == clazz) {
            if (value == null) {
                return (T)Boolean.FALSE;
            }
            if ("Y".equals(value)) {
                return (T)Boolean.TRUE;
            }
            if ("N".equals(value)) {
                return (T)Boolean.FALSE;
            }
            throw new IllegalStateException("Invalid boolean value '" + value + "'");
        }
        throw new IllegalArgumentException("clazz not supported - " + clazz);
    }
}

