/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.adempiere.model.engines.CostDimension;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MResource;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.eevolution.exceptions.BOMExpiredException;
import org.eevolution.exceptions.RoutingExpiredException;
import org.eevolution.model.I_PP_Order;
import org.eevolution.model.I_PP_Order_BOMLine;
import org.eevolution.model.I_PP_Order_Node;
import org.eevolution.model.I_PP_Product_BOM;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderBOM;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPOrderCost;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderNodeAsset;
import org.eevolution.model.MPPOrderNodeNext;
import org.eevolution.model.MPPOrderNodeProduct;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPWFNodeAsset;
import org.eevolution.model.MPPWFNodeProduct;
import org.eevolution.model.MQMSpecification;
import org.eevolution.model.X_PP_Order;

public class MPPOrder
extends X_PP_Order
implements DocAction {
    private static final long serialVersionUID = 1L;
    private MPPOrderBOMLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPOrderWorkflow m_PP_Order_Workflow = null;

    public static MPPOrder forC_OrderLine_ID(Properties ctx, int C_OrderLine_ID, String trxName) {
        MOrderLine line = new MOrderLine(ctx, C_OrderLine_ID, trxName);
        return (MPPOrder)new Query(ctx, "PP_Order", "C_OrderLine_ID=? AND M_Product_ID=?", trxName).setParameters(new Object[]{C_OrderLine_ID, line.getM_Product_ID()}).firstOnly();
    }

    public static void updateQtyBatchs(Properties ctx, I_PP_Order order, boolean override) {
        BigDecimal qtyBatchSize = order.getQtyBatchSize();
        if (qtyBatchSize.signum() == 0 || override) {
            int AD_Workflow_ID = order.getAD_Workflow_ID();
            if (AD_Workflow_ID <= 0) {
                return;
            }
            MWorkflow wf = MWorkflow.get((Properties)ctx, (int)AD_Workflow_ID);
            qtyBatchSize = wf.getQtyBatchSize().setScale(0, RoundingMode.UP);
            order.setQtyBatchSize(qtyBatchSize);
        }
        BigDecimal QtyBatchs = qtyBatchSize.signum() == 0 ? Env.ONE : order.getQtyOrdered().divide(qtyBatchSize, 0, 0);
        order.setQtyBatchs(QtyBatchs);
    }

    public static boolean isQtyAvailable(MPPOrder order, ArrayList[][] issue, Timestamp minGuaranteeDate) {
        boolean isCompleteQtyDeliver = false;
        int i = 0;
        while (i < issue.length) {
            KeyNamePair key = (KeyNamePair)issue[i][0].get(0);
            boolean isSelected = key.getName().equals("Y");
            if (key != null && isSelected) {
                String value = (String)issue[i][0].get(2);
                KeyNamePair productkey = (KeyNamePair)issue[i][0].get(3);
                int M_Product_ID = productkey.getKey();
                BigDecimal qtyToDeliver = (BigDecimal)issue[i][0].get(4);
                BigDecimal qtyScrapComponent = (BigDecimal)issue[i][0].get(5);
                MProduct product = MProduct.get((Properties)order.getCtx(), (int)M_Product_ID);
                if (product != null && product.isStocked()) {
                    MStorage storage;
                    int n;
                    int n2;
                    MStorage[] mStorageArray;
                    int PP_Order_BOMLine_ID;
                    int M_AttributeSetInstance_ID = 0;
                    if (value == null && isSelected) {
                        M_AttributeSetInstance_ID = key.getKey();
                    } else if (value != null && isSelected && (PP_Order_BOMLine_ID = Integer.valueOf(key.getKey()).intValue()) > 0) {
                        MPPOrderBOMLine orderBOMLine = new MPPOrderBOMLine(order.getCtx(), PP_Order_BOMLine_ID, order.get_TrxName());
                        M_AttributeSetInstance_ID = orderBOMLine.getM_AttributeSetInstance_ID();
                    }
                    MStorage[] storages = MPPOrder.getStorages(order.getCtx(), M_Product_ID, order.getM_Warehouse_ID(), M_AttributeSetInstance_ID, minGuaranteeDate, order.get_TrxName());
                    if (M_AttributeSetInstance_ID == 0) {
                        BigDecimal toIssue = qtyToDeliver.add(qtyScrapComponent);
                        mStorageArray = storages;
                        n2 = storages.length;
                        n = 0;
                        while (n < n2) {
                            BigDecimal issueActual;
                            storage = mStorageArray[n];
                            if (storage.getQtyOnHand().signum() == 0 || (toIssue = toIssue.subtract(issueActual = toIssue.min(storage.getQtyOnHand()))).signum() > 0) {
                                ++n;
                                continue;
                            }
                            break;
                        }
                    } else {
                        BigDecimal qtydelivered = qtyToDeliver;
                        qtydelivered.setScale(4, 4);
                        qtydelivered = Env.ZERO;
                    }
                    BigDecimal onHand = Env.ZERO;
                    mStorageArray = storages;
                    n2 = storages.length;
                    n = 0;
                    while (n < n2) {
                        storage = mStorageArray[n];
                        onHand = onHand.add(storage.getQtyOnHand());
                        ++n;
                    }
                    boolean bl = isCompleteQtyDeliver = onHand.compareTo(qtyToDeliver.add(qtyScrapComponent)) >= 0;
                    if (!isCompleteQtyDeliver) break;
                }
            }
            ++i;
        }
        return isCompleteQtyDeliver;
    }

    public static MStorage[] getStorages(Properties ctx, int M_Product_ID, int M_Warehouse_ID, int M_ASI_ID, Timestamp minGuaranteeDate, String trxName) {
        MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
        if (product != null && product.isStocked()) {
            if (product.getM_AttributeSetInstance_ID() == 0) {
                String MMPolicy = product.getMMPolicy();
                return MStorage.getWarehouse((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_ASI_ID, (Timestamp)minGuaranteeDate, (boolean)"F".equals(MMPolicy), (boolean)true, (int)0, (String)trxName);
            }
            String MMPolicy = product.getMMPolicy();
            return MStorage.getWarehouse((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)0, (Timestamp)minGuaranteeDate, (boolean)"F".equals(MMPolicy), (boolean)true, (int)0, (String)trxName);
        }
        return new MStorage[0];
    }

    public MPPOrder(Properties ctx, int PP_Order_ID, String trxName) {
        super(ctx, PP_Order_ID, trxName);
        if (PP_Order_ID == 0) {
            this.setDefault();
        }
    }

    public MPPOrder(MProject project, int PP_Product_BOM_ID, int AD_Workflow_ID) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        this.setLine(10);
        this.setPriorityRule("5");
        if (project.getDateContract() == null) {
            throw new IllegalStateException("Date Contract is mandatory for Manufacturing Order.");
        }
        if (project.getDateFinish() == null) {
            throw new IllegalStateException("Date Finish is mandatory for Manufacturing Order.");
        }
        Timestamp ts = project.getDateContract();
        Timestamp df = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if (ts != null) {
            this.setDateStartSchedule(ts);
        }
        ts = project.getDateFinish();
        if (df != null) {
            this.setDatePromised(df);
        }
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setPP_Product_BOM_ID(PP_Product_BOM_ID);
        this.setAD_Workflow_ID(AD_Workflow_ID);
        this.setQtyEntered(Env.ONE);
        this.setQtyOrdered(Env.ONE);
        MPPProductBOM bom = new MPPProductBOM(project.getCtx(), PP_Product_BOM_ID, project.get_TrxName());
        MProduct product = MProduct.get((Properties)project.getCtx(), (int)bom.getM_Product_ID());
        this.setC_UOM_ID(product.getC_UOM_ID());
        this.setM_Product_ID(bom.getM_Product_ID());
        String where = "IsManufacturingResource = 'Y' AND ManufacturingResourceType = 'PT' AND M_Warehouse_ID = " + project.getM_Warehouse_ID();
        MResource resoruce = (MResource)MTable.get((Properties)project.getCtx(), (int)MResource.Table_ID).getPO(where, project.get_TrxName());
        if (resoruce == null) {
            throw new IllegalStateException("Resource is mandatory.");
        }
        this.setS_Resource_ID(resoruce.getS_Resource_ID());
    }

    public MPPOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public BigDecimal getQtyOpen() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered()).subtract(this.getQtyScrap());
    }

    public MPPOrderBOMLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MPPOrder.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "PP_Order_ID=?";
        List list = new Query(this.getCtx(), "PP_Order_BOMLine", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getPP_Order_ID()}).setOrderBy("Line").list();
        this.m_lines = list.toArray(new MPPOrderBOMLine[list.size()]);
        return this.m_lines;
    }

    public MPPOrderBOMLine[] getLines() {
        return this.getLines(true);
    }

    public void setC_DocTypeTarget_ID(String docBaseType) {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        MDocType[] doc = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)docBaseType);
        if (doc == null) {
            throw new DocTypeNotFoundException(docBaseType, "");
        }
        this.setC_DocTypeTarget_ID(doc[0].get_ID());
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        String sql = "UPDATE PP_Order SET Processed=? WHERE PP_Order_ID=?";
        DB.executeUpdateEx((String)"UPDATE PP_Order SET Processed=? WHERE PP_Order_ID=?", (Object[])new Object[]{processed, this.get_ID()}, (String)this.get_TrxName());
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
            if (context_AD_Org_ID == 0) {
                this.m_processMsg = "AD_Org_ID = 0";
                return false;
            }
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("beforeSave - Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getM_Warehouse_ID() == 0 && (ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_Warehouse_ID")) != 0) {
            this.setM_Warehouse_ID(ii);
        }
        if (this.getC_UOM_ID() <= 0 && this.getM_Product_ID() > 0) {
            this.setC_UOM_ID(this.getM_Product().getC_UOM_ID());
        }
        if (this.getDateFinishSchedule() == null) {
            this.setDateFinishSchedule(this.getDatePromised());
        }
        if (this.is_ValueChanged("QtyDelivered") || this.is_ValueChanged("QtyOrdered")) {
            this.orderStock();
        }
        MPPOrder.updateQtyBatchs(this.getCtx(), (I_PP_Order)this, false);
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if ("CL".equals(this.getDocAction()) || "VO".equals(this.getDocAction())) {
            return true;
        }
        if (this.is_ValueChanged("QtyEntered") && !this.isDelivered()) {
            this.deleteWorkflowAndBOM();
            this.explotion();
        }
        if (this.is_ValueChanged("QtyEntered") && this.isDelivered()) {
            throw new AdempiereException("Cannot Change Quantity, Only is allow with Draft or In Process Status");
        }
        if (!newRecord) {
            return success;
        }
        this.explotion();
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IP")) {
            String whereClause = "PP_Order_ID=? AND AD_Client_ID=?";
            Object[] params = new Object[]{this.get_ID(), this.getAD_Client_ID()};
            this.deletePO("PP_Order_Cost", whereClause, params);
            this.deleteWorkflowAndBOM();
        }
        this.setQtyOrdered(Env.ZERO);
        this.orderStock();
        return true;
    }

    private void deleteWorkflowAndBOM() {
        if (this.get_ID() <= 0) {
            return;
        }
        String whereClause = "PP_Order_ID=? AND AD_Client_ID=?";
        Object[] params = new Object[]{this.get_ID(), this.getAD_Client_ID()};
        DB.executeUpdateEx((String)("UPDATE PP_Order_Workflow SET PP_Order_Node_ID=NULL WHERE " + whereClause), (Object[])params, (String)this.get_TrxName());
        this.deletePO("PP_Order_Node_Asset", whereClause, params);
        this.deletePO("PP_Order_Node_Product", whereClause, params);
        this.deletePO("PP_Order_NodeNext", whereClause, params);
        this.deletePO("PP_Order_Node", whereClause, params);
        this.deletePO("PP_Order_Workflow", whereClause, params);
        this.deletePO("PP_Order_BOMLine", whereClause, params);
        this.deletePO("PP_Order_BOM", whereClause, params);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        String docBaseType;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPPOrderBOMLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getC_DocType_ID() != 0) {
            int i = 0;
            while (i < lines.length) {
                if (lines[i].getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
                    this.log.warning("different Warehouse " + (Object)((Object)lines[i]));
                    this.m_processMsg = "@CannotChangeDocType@";
                    return "IN";
                }
                ++i;
            }
        }
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (!"MQO".equals(docBaseType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID()).getDocBaseType())) {
            this.reserveStock(lines);
            this.orderStock();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private void orderStock() {
        MProduct product = this.getM_Product();
        if (!product.isStocked()) {
            return;
        }
        BigDecimal target = this.getQtyOrdered();
        BigDecimal difference = target.subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        if (difference.signum() == 0) {
            return;
        }
        BigDecimal ordered = difference;
        int M_Locator_ID = this.getM_Locator_ID(ordered);
        if ("CL".equals(this.getDocAction()) ? !MStorage.add((Properties)this.getCtx(), (int)this.getM_Warehouse_ID(), (int)M_Locator_ID, (int)this.getM_Product_ID(), (int)this.getM_AttributeSetInstance_ID(), (int)this.getM_AttributeSetInstance_ID(), (BigDecimal)Env.ZERO, (BigDecimal)Env.ZERO, (BigDecimal)ordered, (String)this.get_TrxName()) : !MStorage.add((Properties)this.getCtx(), (int)this.getM_Warehouse_ID(), (int)M_Locator_ID, (int)this.getM_Product_ID(), (int)this.getM_AttributeSetInstance_ID(), (int)this.getM_AttributeSetInstance_ID(), (BigDecimal)Env.ZERO, (BigDecimal)Env.ZERO, (BigDecimal)ordered, (String)this.get_TrxName())) {
            throw new AdempiereException();
        }
        this.setQtyReserved(this.getQtyReserved().add(difference));
    }

    private void reserveStock(MPPOrderBOMLine[] lines) {
        MPPOrderBOMLine[] mPPOrderBOMLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine line = mPPOrderBOMLineArray[n2];
            line.reserveStock();
            line.saveEx();
            ++n2;
        }
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        MDocType doc = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (doc.getDocBaseType().equals("MQO")) {
            String whereClause = "PP_Product_BOM_ID=? AND AD_Workflow_ID=?";
            MQMSpecification qms = (MQMSpecification)new Query(this.getCtx(), "QM_Specification", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getPP_Product_BOM_ID(), this.getAD_Workflow_ID()}).firstOnly();
            return qms != null ? qms.isValid(this.getM_AttributeSetInstance_ID()) : true;
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.createStandardCosts();
        this.autoReportActivities();
        this.setDocAction("CL");
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        return "CO";
    }

    public boolean isAvailable() {
        String whereClause = "QtyOnHand >= QtyRequiered AND PP_Order_ID=?";
        boolean available = new Query(this.getCtx(), "RV_PP_Order_Storage", whereClause, this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).match();
        return available;
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot void this document because exist transactions");
        }
        MPPOrderBOMLine[] mPPOrderBOMLineArray = this.getLines();
        int n = mPPOrderBOMLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine line = mPPOrderBOMLineArray[n2];
            BigDecimal old = line.getQtyRequiered();
            if (old.signum() != 0) {
                line.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Voided@ @QtyRequiered@ : (" + old + ")")));
                line.setQtyRequiered(Env.ZERO);
                line.saveEx();
            }
            ++n2;
        }
        this.getMPPOrderWorkflow().voidActivities();
        BigDecimal old = this.getQtyOrdered();
        if (old.signum() != 0) {
            this.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Voided@ @QtyOrdered@ : (" + old + ")")));
            this.setQtyOrdered(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus())) {
            return true;
        }
        if (!"CO".equals(this.getDocStatus())) {
            String DocStatus = this.completeIt();
            this.setDocStatus(DocStatus);
            this.setDocAction("--");
        }
        if (!this.isDelivered()) {
            throw new AdempiereException("Cannot close this document because do not exist transactions");
        }
        this.createVariances();
        MPPOrderBOMLine[] mPPOrderBOMLineArray = this.getLines();
        int n = mPPOrderBOMLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine line = mPPOrderBOMLineArray[n2];
            BigDecimal old = line.getQtyRequiered();
            if (old.compareTo(line.getQtyDelivered()) != 0) {
                line.setQtyRequiered(line.getQtyDelivered());
                line.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@closed@ @QtyRequiered@ (" + old + ")")));
                line.saveEx();
            }
            ++n2;
        }
        MPPOrderWorkflow m_order_wf = this.getMPPOrderWorkflow();
        m_order_wf.closeActivities(m_order_wf.getLastNode(this.getAD_Client_ID()), this.getUpdated(), false);
        BigDecimal old = this.getQtyOrdered();
        if (old.signum() != 0) {
            this.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@closed@ @QtyOrdered@ : (" + old + ")")));
            this.setQtyOrdered(this.getQtyDelivered());
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.setDocStatus("CL");
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return this.voidIt();
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot re activate this document because exist transactions");
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public int getDoc_User_ID() {
        return this.getPlanner_ID();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String getSummary() {
        return this.getDocumentNo() + "/" + this.getDatePromised();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)8, (int)this.getPP_Order_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    private void deletePO(String tableName, String whereClause, Object[] params) {
        POResultSet rs = new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(params).scroll();
        try {
            while (rs.hasNext()) {
                rs.next().deleteEx(true);
            }
        }
        finally {
            rs.close();
        }
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setQtyOrdered(BigDecimal QtyOrdered) {
        if (QtyOrdered != null) {
            int precision = this.getM_Product().getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, 4);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    public MProduct getM_Product() {
        return MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
    }

    public MPPOrderBOM getMPPOrderBOM() {
        String whereClause = "PP_Order_ID=?";
        return (MPPOrderBOM)new Query(this.getCtx(), "PP_Order_BOM", "PP_Order_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getPP_Order_ID()}).firstOnly();
    }

    public MPPOrderWorkflow getMPPOrderWorkflow() {
        if (this.m_PP_Order_Workflow != null) {
            return this.m_PP_Order_Workflow;
        }
        String whereClause = "PP_Order_ID=?";
        this.m_PP_Order_Workflow = (MPPOrderWorkflow)new Query(this.getCtx(), "PP_Order_Workflow", "PP_Order_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getPP_Order_ID()}).firstOnly();
        return this.m_PP_Order_Workflow;
    }

    private void explotion() {
        MPPOrderWorkflow PP_Order_Workflow;
        int n;
        MPPProductBOM PP_Product_BOM = MPPProductBOM.get((Properties)this.getCtx(), (int)this.getPP_Product_BOM_ID());
        if (this.getM_Product_ID() != PP_Product_BOM.getM_Product_ID()) {
            throw new AdempiereException("@NotMatch@ @PP_Product_BOM_ID@ , @M_Product_ID@");
        }
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)PP_Product_BOM.getM_Product_ID());
        if (!product.isVerified()) {
            throw new AdempiereException("Product BOM Configuration not verified. Please verify the product first - " + product.getValue());
        }
        if (PP_Product_BOM.isValidFromTo(this.getDateStartSchedule())) {
            MPPOrderBOM PP_Order_BOM = new MPPOrderBOM(PP_Product_BOM, this.getPP_Order_ID(), this.get_TrxName());
            PP_Order_BOM.setAD_Org_ID(this.getAD_Org_ID());
            PP_Order_BOM.saveEx();
            MPPProductBOMLine[] mPPProductBOMLineArray = PP_Product_BOM.getLines(true);
            n = mPPProductBOMLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine PP_Product_BOMline = mPPProductBOMLineArray[n2];
                if (PP_Product_BOMline.isValidFromTo(this.getDateStartSchedule())) {
                    MPPOrderBOMLine PP_Order_BOMLine = new MPPOrderBOMLine(PP_Product_BOMline, this.getPP_Order_ID(), PP_Order_BOM.get_ID(), this.getM_Warehouse_ID(), this.get_TrxName());
                    PP_Order_BOMLine.setAD_Org_ID(this.getAD_Org_ID());
                    PP_Order_BOMLine.setM_Warehouse_ID(this.getM_Warehouse_ID());
                    PP_Order_BOMLine.setM_Locator_ID(this.getM_Locator_ID());
                    PP_Order_BOMLine.setQtyOrdered(this.getQtyOrdered());
                    PP_Order_BOMLine.saveEx();
                } else {
                    this.log.fine("BOM Line skiped - " + PP_Product_BOMline);
                }
                ++n2;
            }
        } else {
            throw new BOMExpiredException((I_PP_Product_BOM)PP_Product_BOM, this.getDateStartSchedule());
        }
        MWorkflow AD_Workflow = MWorkflow.get((Properties)this.getCtx(), (int)this.getAD_Workflow_ID());
        if (!AD_Workflow.isValid()) {
            throw new AdempiereException("Routing is not valid. Please validate it first - " + AD_Workflow.getValue());
        }
        if (AD_Workflow.isValidFromTo(this.getDateStartSchedule())) {
            PP_Order_Workflow = new MPPOrderWorkflow(AD_Workflow, this.get_ID(), this.get_TrxName());
            PP_Order_Workflow.setAD_Org_ID(this.getAD_Org_ID());
            PP_Order_Workflow.saveEx();
            Object[] objectArray = AD_Workflow.getNodes(false, this.getAD_Client_ID());
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                MWFNode AD_WF_Node = objectArray[n];
                if (AD_WF_Node.isValidFromTo(this.getDateStartSchedule())) {
                    MPPOrderNode PP_Order_Node = new MPPOrderNode(AD_WF_Node, PP_Order_Workflow, this.getQtyOrdered(), this.get_TrxName());
                    PP_Order_Node.setAD_Org_ID(this.getAD_Org_ID());
                    PP_Order_Node.saveEx();
                    MWFNodeNext[] mWFNodeNextArray = AD_WF_Node.getTransitions(this.getAD_Client_ID());
                    int n4 = mWFNodeNextArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        MWFNodeNext AD_WF_NodeNext = mWFNodeNextArray[n5];
                        MPPOrderNodeNext nodenext = new MPPOrderNodeNext(AD_WF_NodeNext, PP_Order_Node);
                        nodenext.setAD_Org_ID(this.getAD_Org_ID());
                        nodenext.saveEx();
                        ++n5;
                    }
                    for (MPPWFNodeProduct wfnp : MPPWFNodeProduct.forAD_WF_Node_ID(this.getCtx(), AD_WF_Node.get_ID())) {
                        MPPOrderNodeProduct nodeOrderProduct = new MPPOrderNodeProduct(wfnp, PP_Order_Node);
                        nodeOrderProduct.setAD_Org_ID(this.getAD_Org_ID());
                        nodeOrderProduct.saveEx();
                    }
                    for (MPPWFNodeAsset wfna : MPPWFNodeAsset.forAD_WF_Node_ID(this.getCtx(), AD_WF_Node.get_ID())) {
                        MPPOrderNodeAsset nodeorderasset = new MPPOrderNodeAsset(wfna, PP_Order_Node);
                        nodeorderasset.setAD_Org_ID(this.getAD_Org_ID());
                        nodeorderasset.saveEx();
                    }
                }
                ++n;
            }
            PP_Order_Workflow.getNodes(true);
            objectArray = PP_Order_Workflow.getNodes(false, this.getAD_Client_ID());
            n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                MWFNode orderNode = objectArray[n];
                if (PP_Order_Workflow.getAD_WF_Node_ID() == orderNode.getAD_WF_Node_ID()) {
                    PP_Order_Workflow.setPP_Order_Node_ID(orderNode.getPP_Order_Node_ID());
                }
                MPPOrderNodeNext[] mPPOrderNodeNextArray = orderNode.getTransitions(this.getAD_Client_ID());
                int n6 = mPPOrderNodeNextArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    MPPOrderNodeNext next = mPPOrderNodeNextArray[n7];
                    next.setPP_Order_Next_ID();
                    next.saveEx();
                    ++n7;
                }
                ++n;
            }
        } else {
            throw new RoutingExpiredException((I_AD_Workflow)AD_Workflow, this.getDateStartSchedule());
        }
        PP_Order_Workflow.saveEx();
    }

    public static void createReceipt(MPPOrder order, Timestamp movementDate, BigDecimal qtyDelivered, BigDecimal qtyToDeliver, BigDecimal qtyScrap, BigDecimal qtyReject, int M_Locator_ID, int M_AttributeSetInstance_ID) {
        if (qtyToDeliver.signum() != 0 || qtyScrap.signum() != 0 || qtyReject.signum() != 0) {
            MPPCostCollector.createCollector(order, order.getM_Product_ID(), M_Locator_ID, M_AttributeSetInstance_ID, order.getS_Resource_ID(), 0, 0, MDocType.getDocType((String)"MCC"), "100", movementDate, qtyToDeliver, qtyScrap, qtyReject, 0, Env.ZERO);
        }
        order.setDateDelivered(movementDate);
        if (order.getDateStart() == null) {
            order.setDateStart(movementDate);
        }
        BigDecimal DQ = qtyDelivered;
        BigDecimal SQ = qtyScrap;
        BigDecimal OQ = qtyToDeliver;
        if (DQ.add(SQ).compareTo(OQ) >= 0) {
            order.setDateFinish(movementDate);
        }
        order.saveEx();
    }

    public static void createIssue(MPPOrder order, int PP_OrderBOMLine_ID, Timestamp movementdate, BigDecimal qty, BigDecimal qtyScrap, BigDecimal qtyReject, MStorage[] storages, boolean forceIssue) {
        if (qty.signum() == 0) {
            return;
        }
        MPPOrderBOMLine PP_orderbomLine = new MPPOrderBOMLine(order.getCtx(), PP_OrderBOMLine_ID, order.get_TrxName());
        BigDecimal toIssue = qty.add(qtyScrap);
        MStorage[] mStorageArray = storages;
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            MStorage storage = mStorageArray[n2];
            if (storage.getQtyOnHand().signum() != 0) {
                BigDecimal qtyIssue = toIssue.min(storage.getQtyOnHand());
                if (qtyIssue.signum() != 0 || qtyScrap.signum() != 0 || qtyReject.signum() != 0) {
                    String CostCollectorType = "110";
                    if (PP_orderbomLine.getQtyBatch().signum() == 0 && PP_orderbomLine.getQtyBOM().signum() == 0) {
                        CostCollectorType = "130";
                    } else if (PP_orderbomLine.isComponentType("CP")) {
                        CostCollectorType = "150";
                    }
                    MPPCostCollector.createCollector(order, PP_orderbomLine.getM_Product_ID(), storage.getM_Locator_ID(), storage.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), PP_OrderBOMLine_ID, 0, MDocType.getDocType((String)"MCC"), CostCollectorType, movementdate, qtyIssue, qtyScrap, qtyReject, 0, Env.ZERO);
                }
                if ((toIssue = toIssue.subtract(qtyIssue)).signum() == 0) break;
            }
            ++n2;
        }
        if (forceIssue && toIssue.signum() != 0) {
            MPPCostCollector.createCollector(order, PP_orderbomLine.getM_Product_ID(), PP_orderbomLine.getM_Locator_ID(), PP_orderbomLine.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), PP_OrderBOMLine_ID, 0, MDocType.getDocType((String)"MCC"), "110", movementdate, toIssue, Env.ZERO, Env.ZERO, 0, Env.ZERO);
            return;
        }
        if (toIssue.signum() != 0) {
            throw new AdempiereException("Should not happen toIssue=" + toIssue);
        }
    }

    public static boolean isQtyAvailable(MPPOrder order, I_PP_Order_BOMLine line) {
        MProduct product = MProduct.get((Properties)order.getCtx(), (int)line.getM_Product_ID());
        if (product == null || !product.isStocked()) {
            return true;
        }
        BigDecimal qtyToDeliver = line.getQtyRequiered();
        BigDecimal qtyScrap = line.getQtyScrap();
        BigDecimal qtyRequired = qtyToDeliver.add(qtyScrap);
        BigDecimal qtyAvailable = MStorage.getQtyAvailable((int)order.getM_Warehouse_ID(), (int)0, (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (String)order.get_TrxName());
        return qtyAvailable.compareTo(qtyRequired) >= 0;
    }

    public int getM_Locator_ID() {
        MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID());
        return wh.getDefaultLocator().getM_Locator_ID();
    }

    private int getM_Locator_ID(BigDecimal qty) {
        int M_Locator_ID = 0;
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if (M_ASI_ID != 0) {
            M_Locator_ID = MStorage.getM_Locator_ID((int)this.getM_Warehouse_ID(), (int)this.getM_Product_ID(), (int)M_ASI_ID, (BigDecimal)qty, (String)this.get_TrxName());
        }
        if (M_Locator_ID == 0) {
            M_Locator_ID = this.getM_Locator_ID();
        }
        return M_Locator_ID;
    }

    public boolean isDelivered() {
        if (this.getQtyDelivered().signum() > 0 || this.getQtyScrap().signum() > 0 || this.getQtyReject().signum() > 0) {
            return true;
        }
        Object[] objectArray = this.getLines();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine line = objectArray[n2];
            if (line.getQtyDelivered().signum() > 0) {
                return true;
            }
            ++n2;
        }
        objectArray = this.getMPPOrderWorkflow().getNodes(true, this.getAD_Client_ID());
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine node = objectArray[n2];
            if (node.getQtyDelivered().signum() > 0) {
                return true;
            }
            if (node.getDurationReal() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setDefault() {
        this.setLine(10);
        this.setPriorityRule("5");
        this.setDescription("");
        this.setQtyDelivered(Env.ZERO);
        this.setQtyReject(Env.ZERO);
        this.setQtyScrap(Env.ZERO);
        this.setIsSelected(false);
        this.setIsSOTrx(false);
        this.setIsApproved(false);
        this.setIsPrinted(false);
        this.setProcessed(false);
        this.setProcessing(false);
        this.setPosted(false);
        this.setC_DocTypeTarget_ID("MOP");
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        this.setDocStatus("DR");
        this.setDocAction("PR");
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPPOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return sb.toString();
    }

    public void autoReportActivities() {
        for (MPPOrderNode activity : this.getMPPOrderWorkflow().getNodes()) {
            if (!activity.isMilestone() || !activity.isSubcontracting() && activity.get_ID() != this.getMPPOrderWorkflow().getPP_Order_Node_ID()) continue;
            MPPCostCollector mPPCostCollector = MPPCostCollector.createCollector(this, this.getM_Product_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID(), this.getS_Resource_ID(), 0, activity.getPP_Order_Node_ID(), MDocType.getDocType((String)"MCC"), "160", this.getUpdated(), activity.getQtyToDeliver(), Env.ZERO, Env.ZERO, 0, Env.ZERO);
        }
    }

    private final void createStandardCosts() {
        MCost cost2;
        MAcctSchema as = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getAcctSchema();
        this.log.info("Cost_Group_ID" + as.getM_CostType_ID());
        TreeSet<Integer> productsAdded = new TreeSet<Integer>();
        MProduct product = this.getM_Product();
        productsAdded.add(product.getM_Product_ID());
        CostDimension d = new CostDimension(product, as, as.getM_CostType_ID(), this.getAD_Org_ID(), this.getM_AttributeSetInstance_ID(), -10);
        List costs22 = d.toQuery(MCost.class, this.get_TrxName()).list();
        for (MCost cost2 : costs22) {
            MPPOrderCost PP_Order_Cost = new MPPOrderCost(cost2, this.get_ID(), this.get_TrxName());
            PP_Order_Cost.saveEx();
        }
        cost2 = this.getLines();
        int costs22 = ((MCost)cost2).length;
        int n = 0;
        while (n < costs22) {
            MCost line = cost2[n];
            MProduct product2 = line.getM_Product();
            if (!productsAdded.contains(product2.getM_Product_ID())) {
                productsAdded.add(product2.getM_Product_ID());
                CostDimension d2 = new CostDimension(line.getM_Product(), as, as.getM_CostType_ID(), line.getAD_Org_ID(), line.getM_AttributeSetInstance_ID(), -10);
                List costs = d2.toQuery(MCost.class, this.get_TrxName()).list();
                for (MCost cost3 : costs) {
                    MPPOrderCost PP_Order_Cost = new MPPOrderCost(cost3, this.get_ID(), this.get_TrxName());
                    PP_Order_Cost.saveEx();
                }
            }
            ++n;
        }
        for (MPPOrderNode node : this.getMPPOrderWorkflow().getNodes(true)) {
            MProduct resourceProduct;
            int S_Resource_ID = node.getS_Resource_ID();
            if (S_Resource_ID <= 0 || productsAdded.contains((resourceProduct = MProduct.forS_Resource_ID((Properties)this.getCtx(), (int)S_Resource_ID, null)).getM_Product_ID())) continue;
            productsAdded.add(resourceProduct.getM_Product_ID());
            CostDimension d3 = new CostDimension(resourceProduct, as, as.getM_CostType_ID(), node.getAD_Org_ID(), 0, -10);
            List costs = d3.toQuery(MCost.class, this.get_TrxName()).list();
            for (MCost cost4 : costs) {
                MPPOrderCost orderCost = new MPPOrderCost(cost4, this.getPP_Order_ID(), this.get_TrxName());
                orderCost.saveEx();
            }
        }
    }

    public void createVariances() {
        MPPOrderBOMLine[] mPPOrderBOMLineArray = this.getLines(true);
        int n = mPPOrderBOMLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPPOrderBOMLine line = mPPOrderBOMLineArray[n2];
            this.createUsageVariance((I_PP_Order_BOMLine)line);
            ++n2;
        }
        this.m_lines = null;
        MPPOrderWorkflow orderWorkflow = this.getMPPOrderWorkflow();
        if (orderWorkflow != null) {
            for (MPPOrderNode node : orderWorkflow.getNodes(true)) {
                this.createUsageVariance((I_PP_Order_Node)node);
            }
        }
    }

    private void createUsageVariance(I_PP_Order_BOMLine bomLine) {
        MLocator locator;
        MPPOrder order = this;
        Timestamp movementDate = order.getUpdated();
        MPPOrderBOMLine line = (MPPOrderBOMLine)bomLine;
        if (line.getQtyBatch().signum() == 0 && line.getQtyBOM().signum() == 0) {
            return;
        }
        BigDecimal qtyUsageVariancePrev = line.getQtyVariance();
        BigDecimal qtyOpen = line.getQtyOpen();
        BigDecimal qtyUsageVariance = qtyOpen.subtract(qtyUsageVariancePrev);
        if (qtyUsageVariance.signum() == 0) {
            return;
        }
        int M_Locator_ID = line.getM_Locator_ID();
        if (M_Locator_ID <= 0 && (locator = MLocator.getDefault((MWarehouse)MWarehouse.get((Properties)order.getCtx(), (int)order.getM_Warehouse_ID()))) != null) {
            M_Locator_ID = locator.getM_Locator_ID();
        }
        MPPCostCollector.createCollector(order, line.getM_Product_ID(), M_Locator_ID, line.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), line.getPP_Order_BOMLine_ID(), 0, MDocType.getDocType((String)"MCC"), "120", movementDate, qtyUsageVariance, Env.ZERO, Env.ZERO, 0, Env.ZERO);
    }

    private void createUsageVariance(I_PP_Order_Node orderNode) {
        MPPOrder order = this;
        Timestamp movementDate = order.getUpdated();
        MPPOrderNode node = (MPPOrderNode)orderNode;
        BigDecimal setupTimeReal = BigDecimal.valueOf(node.getSetupTimeReal());
        BigDecimal durationReal = BigDecimal.valueOf(node.getDurationReal());
        if (setupTimeReal.signum() == 0 && durationReal.signum() == 0) {
            return;
        }
        BigDecimal setupTimeVariancePrev = node.getSetupTimeUsageVariance();
        BigDecimal durationVariancePrev = node.getDurationUsageVariance();
        BigDecimal setupTimeRequired = BigDecimal.valueOf(node.getSetupTimeRequiered());
        BigDecimal durationRequired = BigDecimal.valueOf(node.getDurationRequiered());
        BigDecimal qtyOpen = node.getQtyToDeliver();
        BigDecimal setupTimeVariance = setupTimeRequired.subtract(setupTimeReal).subtract(setupTimeVariancePrev);
        BigDecimal durationVariance = durationRequired.subtract(durationReal).subtract(durationVariancePrev);
        if (qtyOpen.signum() == 0 && setupTimeVariance.signum() == 0 && durationVariance.signum() == 0) {
            return;
        }
        MPPCostCollector.createCollector(order, order.getM_Product_ID(), order.getM_Locator_ID(), order.getM_AttributeSetInstance_ID(), node.getS_Resource_ID(), 0, node.getPP_Order_Node_ID(), MDocType.getDocType((String)"MCC"), "120", movementDate, qtyOpen, Env.ZERO, Env.ZERO, setupTimeVariance.intValueExact(), durationVariance);
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered());
    }

    public void updateMakeToKit(BigDecimal qtyShipment) {
        MPPOrderBOM obom = this.getMPPOrderBOM();
        this.getLines(true);
        if ("K".equals(obom.getBOMType()) && "M".equals(obom.getBOMUse())) {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            ArrayList[][] issue = new ArrayList[this.m_lines.length][1];
            int i = 0;
            while (i < this.getLines().length) {
                MPPOrderBOMLine line = this.m_lines[i];
                KeyNamePair id = null;
                id = "1".equals(line.getIssueMethod()) ? new KeyNamePair(line.get_ID(), "Y") : new KeyNamePair(line.get_ID(), "N");
                ArrayList<Object> data = new ArrayList<Object>();
                BigDecimal qtyToDeliver = qtyShipment.multiply(line.getQtyMultiplier());
                data.add(id);
                data.add(line.isCritical());
                MProduct product = line.getM_Product();
                data.add(product.getValue());
                KeyNamePair productKey = new KeyNamePair(product.get_ID(), product.getName());
                data.add(productKey);
                data.add(qtyToDeliver);
                data.add(Env.ZERO);
                issue[i][0] = data;
                ++i;
            }
            boolean forceIssue = false;
            MOrderLine oline = (MOrderLine)this.getC_OrderLine();
            if ("L".equals(oline.getParent().getDeliveryRule()) || "O".equals(oline.getParent().getDeliveryRule())) {
                boolean isCompleteQtyDeliver = MPPOrder.isQtyAvailable(this, issue, today);
                if (!isCompleteQtyDeliver) {
                    throw new AdempiereException("@NoQtyAvailable@");
                }
            } else {
                if ("A".equals(oline.getParent().getDeliveryRule()) || "R".equals(oline.getParent().getDeliveryRule()) || "M".equals(oline.getParent().getDeliveryRule())) {
                    throw new AdempiereException("@ActionNotSupported@");
                }
                if ("F".equals(oline.getParent().getDeliveryRule())) {
                    forceIssue = true;
                }
            }
            int i2 = 0;
            while (i2 < issue.length) {
                int M_AttributeSetInstance_ID = 0;
                KeyNamePair key = (KeyNamePair)issue[i2][0].get(0);
                Boolean isCritical = (Boolean)issue[i2][0].get(1);
                String value = (String)issue[i2][0].get(2);
                KeyNamePair productkey = (KeyNamePair)issue[i2][0].get(3);
                int M_Product_ID = productkey.getKey();
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)M_Product_ID);
                BigDecimal qtyToDeliver = (BigDecimal)issue[i2][0].get(4);
                BigDecimal qtyScrapComponent = (BigDecimal)issue[i2][0].get(5);
                int PP_Order_BOMLine_ID = key.getKey();
                if (PP_Order_BOMLine_ID > 0) {
                    MPPOrderBOMLine orderBOMLine = new MPPOrderBOMLine(this.getCtx(), PP_Order_BOMLine_ID, this.get_TrxName());
                    M_AttributeSetInstance_ID = orderBOMLine.getM_AttributeSetInstance_ID();
                }
                MStorage[] storages = MPPOrder.getStorages(this.getCtx(), M_Product_ID, this.getM_Warehouse_ID(), M_AttributeSetInstance_ID, today, this.get_TrxName());
                MPPOrder.createIssue(this, key.getKey(), today, qtyToDeliver, qtyScrapComponent, Env.ZERO, storages, forceIssue);
                ++i2;
            }
            MPPOrder.createReceipt(this, today, this.getQtyDelivered(), qtyShipment, this.getQtyScrap(), this.getQtyReject(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID());
        }
    }
}

