/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import org.compiere.model.PO;
import org.eevolution.tools.swing.SwingTool;
import org.eevolution.tools.worker.SingleWorker;

public abstract class PopupAction
extends JMenuItem
implements ActionListener {
    protected final ResourceBundle language = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".language");
    protected PropertyChangeSupport propertyChange;
    protected boolean success;
    protected boolean ignoreChange;
    protected SingleWorker worker;
    protected String errorMsg;

    protected abstract void doAction(ActionEvent var1);

    protected abstract String getCommand();

    protected abstract String validateAction();

    protected boolean successful() {
        return this.success;
    }

    public String getSuccessMsg() {
        return "OK";
    }

    protected void setError(String msg) {
        this.errorMsg = msg;
        this.success = false;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public PopupAction(String property) {
        this.setText(this.language.getString(property));
        this.setActionCommand(this.getCommand());
        this.init();
        this.addActionListener(this);
    }

    protected void init() {
        this.success = true;
        this.ignoreChange = false;
    }

    protected void beforeAction() {
        this.init();
        String valid = this.validateAction();
        if (valid != null) {
            this.setError(valid);
            return;
        }
        SwingTool.setCursorsFromChild(this, true);
    }

    protected void afterAction() {
        if (!this.isIgnoreChange()) {
            this.propertyChange.firePropertyChange(this.getCommand(), false, this.successful());
        }
        SwingTool.setCursorsFromChild(this, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ActionEvent evt = e;
        this.worker = new SingleWorker(){

            @Override
            protected Object doIt() {
                PopupAction.this.run(evt);
                return null;
            }
        };
        this.worker.start();
    }

    protected void run(ActionEvent e) {
        this.beforeAction();
        if (this.getActionCommand() != null && this.getActionCommand().equals(e.getActionCommand())) {
            this.doAction(e);
        }
        this.afterAction();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        this.propertyChange.addPropertyChangeListener(listener);
    }

    protected void setIgnoreChange(boolean ignore) {
        this.ignoreChange = ignore;
    }

    public boolean isIgnoreChange() {
        return this.ignoreChange;
    }

    protected void savePO(PO po) {
        this.success = po.save(null);
    }

    protected void deletePO(PO po) {
        this.success = po.delete(true, null);
    }
}

