/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.crp.CRPDatasetFactory;
import org.eevolution.form.crp.CRPModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class VCRP
extends CPanel
implements FormPanel,
ActionListener {
    private static CLogger log = CLogger.getCLogger(VCRP.class);
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CPanel northPanel = new CPanel();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Hashtable hash = new Hashtable();
    private VLookup resource = null;
    private CLabel resourceLabel = new CLabel();
    private VDate dateFrom = new VDate("DateFrom", true, false, true, 15, "DateFrom");
    private CLabel dateFromLabel = new CLabel();
    private int AD_Client_ID = Integer.parseInt(Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_ID"));
    private ChartPanel chartPanel = new ChartPanel(this.createChart((CategoryDataset)new DefaultCategoryDataset(), "", null));
    protected CRPModel model;

    public void init(int WindowNo, FormFrame frame) {
        log.info("VCRP.init");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.fillPicks();
            this.jbInit();
            frame.getContentPane().add((Component)this.northPanel, "North");
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
            frame.pack();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VCRP.init", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.northPanel.setLayout((LayoutManager)new GridBagLayout());
        this.resourceLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
        this.northPanel.add((Component)this.resourceLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.resource, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.dateFromLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.northPanel.add((Component)this.dateFromLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFrom, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.chartPanel.setPreferredSize(new Dimension(750, 550));
        this.centerPanel.add((Component)this.chartPanel, (Object)"Center");
        this.confirmPanel.addActionListener((ActionListener)this);
    }

    private void fillPicks() throws Exception {
        Properties ctx = Env.getCtx();
        MLookup resourceL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"M_Product", (String)"S_Resource_ID"), (int)19);
        this.resource = new VLookup("S_Resource_ID", false, false, true, (Lookup)resourceL);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            Timestamp date = (Timestamp)this.dateFrom.getValue();
            int S_Resource_ID = (Integer)this.resource.getValue();
            System.out.println("ConfirmPanel.A_OK");
            System.out.println("date" + date + " S_Resource_ID " + S_Resource_ID);
            if (date != null && S_Resource_ID != 0) {
                System.out.println("Call createDataset(date,S_Resource_ID)");
                MResource r = MResource.get((Properties)Env.getCtx(), (int)S_Resource_ID);
                int uom_id = r.getResourceType().getC_UOM_ID();
                MUOM uom = MUOM.get((Properties)Env.getCtx(), (int)uom_id);
                CategoryDataset dataset = null;
                if (uom.isHour()) {
                    System.out.println("\n ->is Hour<- \n");
                    dataset = this.createDataset(date, r);
                } else {
                    System.out.println("\n ->is not Hour<- \n");
                    dataset = this.createWeightDataset(date, r);
                }
                System.out.println("dataset.getRowCount:" + dataset.getRowCount());
                String title = r.getName() != null ? r.getName() : "";
                title = String.valueOf(title) + " " + r.getDescription() != null ? r.getDescription() : "";
                JFreeChart jfreechart = this.createChart(dataset, title, uom);
                this.centerPanel.removeAll();
                this.chartPanel = new ChartPanel(jfreechart, false);
                this.centerPanel.add((Component)this.chartPanel, (Object)"Center");
                this.centerPanel.setVisible(true);
                this.m_frame.pack();
            }
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private JFreeChart createChart(CategoryDataset dataset, String title, MUOM uom) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)title, (String)" ", (String)" ", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart = uom == null || uom.isHour() ? ChartFactory.createBarChart3D((String)title, (String)Msg.translate((Properties)Env.getCtx(), (String)"Days"), (String)Msg.translate((Properties)Env.getCtx(), (String)"Hours"), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createBarChart3D((String)title, (String)Msg.translate((Properties)Env.getCtx(), (String)"Days"), (String)Msg.translate((Properties)Env.getCtx(), (String)"Kilo"), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    public CategoryDataset createWeightDataset(Timestamp start, MResource r) {
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTimeInMillis(start.getTime());
        gc1.clear(14);
        gc1.clear(13);
        gc1.clear(12);
        gc1.clear(11);
        String namecapacity = Msg.translate((Properties)Env.getCtx(), (String)"Capacity");
        String nameload = Msg.translate((Properties)Env.getCtx(), (String)"Load");
        String namesummary = Msg.translate((Properties)Env.getCtx(), (String)"Summary");
        String namepossiblecapacity = "Possible Capacity";
        MResourceType t = MResourceType.get((Properties)Env.getCtx(), (int)r.getS_ResourceType_ID());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        double currentweight = DB.getSQLValue(null, (String)"Select SUM( (mo.qtyordered-mo.qtydelivered)*(Select mp.weight From m_product mp Where mo.m_product_id=mp.m_product_id )  )From PP_order mo Where ad_client_id=?", (int)r.getAD_Client_ID());
        double dailyCapacity = r.getDailyCapacity().doubleValue();
        double utilization = r.getPercentUtilization().doubleValue();
        double summary = 0.0;
        int day = 0;
        while (day < 32) {
            ++day;
            switch (gc1.get(7)) {
                case 1: {
                    if (t.isOnSunday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 2: {
                    if (t.isOnMonday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 3: {
                    if (t.isOnTuesday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 4: {
                    if (t.isOnWednesday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 5: {
                    if (t.isOnThursday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 6: {
                    if (t.isOnFriday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                    break;
                }
                case 7: {
                    if (t.isOnSaturday()) {
                        currentweight -= dailyCapacity * utilization / 100.0;
                        summary += dailyCapacity * utilization / 100.0;
                        dataset.addValue(dailyCapacity, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                        dataset.addValue(dailyCapacity * utilization / 100.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namepossiblecapacity), (Comparable)new Integer(day));
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)new Integer(day));
                }
            }
            dataset.addValue(currentweight, (Comparable)((Object)nameload), (Comparable)new Integer(day));
            dataset.addValue(summary, (Comparable)((Object)namesummary), (Comparable)new Integer(day));
            gc1.add(5, 1);
        }
        return dataset;
    }

    public CategoryDataset createDataset(Timestamp start, MResource r) {
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTimeInMillis(start.getTime());
        gc1.clear(14);
        gc1.clear(13);
        gc1.clear(12);
        gc1.clear(11);
        Timestamp date = start;
        String namecapacity = Msg.translate((Properties)Env.getCtx(), (String)"Capacity");
        System.out.println("\n Namecapacity :" + namecapacity);
        String nameload = Msg.translate((Properties)Env.getCtx(), (String)"Load");
        System.out.println("\n Nameload :" + nameload);
        String namesummary = Msg.translate((Properties)Env.getCtx(), (String)"Summary");
        System.out.println("\n Namesummary :" + namesummary);
        MResourceType t = MResourceType.get((Properties)Env.getCtx(), (int)r.getS_ResourceType_ID());
        System.out.println("\n Resourcetype " + t);
        int days = 1;
        long hours = t.getTimeSlotHours();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int C_UOM_ID = DB.getSQLValue(null, (String)"SELECT C_UOM_ID FROM M_Product WHERE S_Resource_ID = ? ", (int)r.getS_Resource_ID());
        MUOM uom = MUOM.get((Properties)Env.getCtx(), (int)C_UOM_ID);
        System.out.println("\n uom1 " + uom + "\n");
        if (!uom.isHour()) {
            System.out.println("\n uom2 " + uom + "\n");
            return dataset;
        }
        System.out.println("\n Dataset " + dataset + "\n");
        long summary = 0L;
        while (days < 32) {
            String day = new String(new Integer(date.getDate()).toString());
            System.out.println("r.getS_Resource_ID()" + r.getS_Resource_ID());
            System.out.println("Date:" + date);
            long HoursLoad = this.getLoad(r, date).longValue();
            Long Hours = new Long(hours);
            System.out.println("Summary " + summary);
            System.out.println("Hours Load " + HoursLoad);
            switch (gc1.get(7)) {
                case 1: {
                    ++days;
                    if (t.isOnSunday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 2: {
                    ++days;
                    if (t.isOnMonday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 3: {
                    ++days;
                    if (t.isOnTuesday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 4: {
                    ++days;
                    if (t.isOnWednesday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 5: {
                    ++days;
                    if (t.isOnThursday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 6: {
                    ++days;
                    if (t.isOnFriday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                    break;
                }
                case 7: {
                    ++days;
                    if (t.isOnSaturday()) {
                        dataset.addValue((double)hours, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                        dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                        dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                        summary = summary + (long)Hours.intValue() - HoursLoad;
                        gc1.add(5, 1);
                        date = new Timestamp(gc1.getTimeInMillis());
                        break;
                    }
                    dataset.addValue(0.0, (Comparable)((Object)namecapacity), (Comparable)((Object)day));
                    dataset.addValue((double)HoursLoad, (Comparable)((Object)nameload), (Comparable)((Object)day));
                    dataset.addValue((double)summary, (Comparable)((Object)namesummary), (Comparable)((Object)day));
                    summary -= HoursLoad;
                    gc1.add(5, 1);
                    date = new Timestamp(gc1.getTimeInMillis());
                }
            }
        }
        return dataset;
    }

    private BigDecimal getLoad(MResource r, Timestamp start) {
        this.model = CRPDatasetFactory.get(start, start, r);
        return this.model.calculateLoad(start, r, null);
    }
}

