/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import org.mvel.ASTLinkedList;
import org.mvel.ASTNode;
import org.mvel.ast.And;
import org.mvel.ast.BinaryOperation;
import org.mvel.ast.EndOfStatement;
import org.mvel.ast.Or;

public class CompilerTools {
    public static ASTLinkedList optimizeAST(ASTLinkedList astLinkedList, boolean secondPassOptimization) {
        ASTNode tkOp2;
        ASTNode tkOp;
        ASTNode tk;
        ASTLinkedList optimizedAst = new ASTLinkedList();
        while (astLinkedList.hasMoreNodes()) {
            tk = astLinkedList.nextNode();
            if (tk.getFields() == -1) {
                optimizedAst.addTokenNode(tk);
                continue;
            }
            if (astLinkedList.hasMoreNodes()) {
                tkOp = astLinkedList.nextNode();
                if (tkOp.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    if (tk instanceof EndOfStatement) {
                        astLinkedList.setCurrentNode(tkOp);
                        continue;
                    }
                    optimizedAst.addTokenNode(tkOp);
                    continue;
                }
                if (tkOp.isOperator() && tkOp.getOperator() < 12) {
                    BinaryOperation bo = new BinaryOperation(tkOp.getOperator(), tk, astLinkedList.nextNode());
                    tkOp2 = null;
                    while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && tkOp2.getFields() != -1 && tkOp2.getOperator() < 12) {
                        tkOp = tkOp2;
                        bo = new BinaryOperation(tkOp.getOperator(), bo, astLinkedList.nextNode());
                    }
                    optimizedAst.addTokenNode(bo);
                    if (tkOp2 == null || tkOp2 == tkOp) continue;
                    optimizedAst.addTokenNode(tkOp2);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
                if (tk instanceof EndOfStatement) {
                    astLinkedList.setCurrentNode(tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tkOp);
                continue;
            }
            optimizedAst.addTokenNode(tk);
        }
        if (secondPassOptimization) {
            astLinkedList = optimizedAst;
            astLinkedList.reset();
            optimizedAst = new ASTLinkedList();
            while (astLinkedList.hasMoreNodes()) {
                tk = astLinkedList.nextNode();
                if (tk.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    continue;
                }
                if (astLinkedList.hasMoreNodes()) {
                    tkOp = astLinkedList.nextNode();
                    if (tkOp.getFields() == -1) {
                        optimizedAst.addTokenNode(tk);
                        if (tk instanceof EndOfStatement) {
                            astLinkedList.setCurrentNode(tkOp);
                        }
                        optimizedAst.addTokenNode(tkOp);
                        continue;
                    }
                    if (tkOp.isOperator() && (tkOp.getOperator() == 12 || tkOp.getOperator() == 13)) {
                        tkOp2 = null;
                        ASTNode bool = null;
                        switch (tkOp.getOperator()) {
                            case 12: {
                                bool = new And(tk, astLinkedList.nextNode());
                                break;
                            }
                            case 13: {
                                bool = new Or(tk, astLinkedList.nextNode());
                            }
                        }
                        while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && (tkOp2.isOperator(new Integer(12)) || tkOp2.isOperator(new Integer(13)))) {
                            tkOp = tkOp2;
                            switch (tkOp.getOperator()) {
                                case 12: {
                                    bool = new And(bool, astLinkedList.nextNode());
                                    break;
                                }
                                case 13: {
                                    bool = new Or(bool, astLinkedList.nextNode());
                                }
                            }
                        }
                        optimizedAst.addTokenNode(bool);
                        if (tkOp2 == null || tkOp2 == tkOp) continue;
                        optimizedAst.addTokenNode(tkOp2);
                        continue;
                    }
                    optimizedAst.addTokenNode(tk);
                    if (tk instanceof EndOfStatement) {
                        astLinkedList.setCurrentNode(tkOp);
                    }
                    optimizedAst.addTokenNode(tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
            }
        }
        return optimizedAst;
    }

    public static boolean isOperator(char item) {
        switch (item) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '<': 
            case '>': 
            case '^': 
            case '|': {
                return true;
            }
        }
        return false;
    }
}

