/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.CompileException;
import org.mvel.ForeachContext;
import org.mvel.MVEL;
import org.mvel.MVELInterpretedRuntime;
import org.mvel.Node;
import org.mvel.PropertyAccessor;
import org.mvel.TemplateCompiler;
import org.mvel.TemplateRegistry;
import org.mvel.util.ExecutionStack;
import org.mvel.util.StringAppender;

public class TemplateInterpreter {
    public static boolean cacheAggressively = false;
    private char[] expression;
    private boolean debug = false;
    private Node[] nodes;
    private int node = 0;
    private static final Map<CharSequence, char[]> EX_PRECACHE;
    private static final Map<Object, Node[]> EX_NODE_CACHE;
    private static final Map<Object, Serializable> EX_PRECOMP_CACHE;
    private static boolean CACHE_DISABLE;
    private ExecutionStack stack;
    private ExecutionStack localStack;

    static {
        CACHE_DISABLE = false;
        if (MVEL.THREAD_SAFE) {
            EX_PRECACHE = Collections.synchronizedMap(new WeakHashMap());
            EX_NODE_CACHE = Collections.synchronizedMap(new WeakHashMap());
            EX_PRECOMP_CACHE = Collections.synchronizedMap(new WeakHashMap());
        } else if (MVEL.WEAK_CACHE || MVEL.NO_JIT) {
            EX_PRECACHE = new WeakHashMap<CharSequence, char[]>();
            EX_NODE_CACHE = new WeakHashMap<Object, Node[]>();
            EX_PRECOMP_CACHE = new WeakHashMap<Object, Serializable>();
        } else {
            EX_PRECACHE = new HashMap<CharSequence, char[]>();
            EX_NODE_CACHE = new HashMap<Object, Node[]>();
            EX_PRECOMP_CACHE = new HashMap<Object, Serializable>();
        }
    }

    public static String evalToString(String template, Object ctx) {
        return String.valueOf(TemplateInterpreter.eval(template, ctx));
    }

    public static String evalToString(String template, Map variables) {
        return String.valueOf(TemplateInterpreter.eval(template, variables));
    }

    public static String evalToString(String template, Object ctx, Map variables) {
        return String.valueOf(TemplateInterpreter.eval(template, ctx, variables));
    }

    public static Object eval(String template, Object ctx) {
        if (template == null) {
            return null;
        }
        return new TemplateInterpreter(template).execute(ctx, null);
    }

    public static Object eval(String template, Map variables) {
        return new TemplateInterpreter(template).execute(null, variables);
    }

    public static Object eval(String template, Object ctx, Map variables) {
        if (template == null) {
            return null;
        }
        return new TemplateInterpreter(template).execute(ctx, variables);
    }

    static void configureFactory() {
    }

    public TemplateInterpreter(CharSequence template) {
        if (CACHE_DISABLE) {
            this.nodes = new TemplateCompiler(this).compileExpression();
        } else if (!EX_PRECACHE.containsKey(template)) {
            this.expression = template.toString().toCharArray();
            EX_PRECACHE.put(template, this.expression);
            this.nodes = new TemplateCompiler(this).compileExpression();
            Node[] nodes = this.cloneAll(EX_NODE_CACHE.get(this.expression));
            EX_NODE_CACHE.put(template, nodes);
        } else {
            this.expression = EX_PRECACHE.get(template);
            try {
                this.nodes = this.cloneAll(EX_NODE_CACHE.get(this.expression));
            }
            catch (NullPointerException e) {
                EX_NODE_CACHE.remove(this.expression);
                this.nodes = new TemplateCompiler(this).compileExpression();
                EX_NODE_CACHE.put(this.expression, this.cloneAll(this.nodes));
            }
        }
    }

    private Node[] cloneAll(Node[] nodes) {
        Node[] newNodes = new Node[nodes.length];
        try {
            int i = 0;
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node n3 = nodeArray[n2];
                newNodes[i++] = n3.clone();
                ++n2;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newNodes;
    }

    public TemplateInterpreter(String expression) {
        if (CACHE_DISABLE) {
            this.nodes = new TemplateCompiler(this).compileExpression();
        } else if (!EX_PRECACHE.containsKey(expression)) {
            this.expression = expression.toCharArray();
            EX_PRECACHE.put(expression, this.expression);
            this.nodes = new TemplateCompiler(this).compileExpression();
            EX_NODE_CACHE.put(expression, this.nodes);
            this.nodes = this.cloneAll(this.nodes);
        } else {
            try {
                this.expression = EX_PRECACHE.get(expression);
                this.nodes = this.cloneAll(EX_NODE_CACHE.get(this.expression));
            }
            catch (NullPointerException e) {
                EX_NODE_CACHE.remove(expression);
                this.nodes = new TemplateCompiler(this).compileExpression();
                EX_NODE_CACHE.put(expression, this.nodes);
                this.nodes = this.cloneAll(this.nodes);
            }
        }
    }

    public TemplateInterpreter(char[] expression) {
        this.expression = expression;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void parseToStream(File template, Object ctx, Map tokens, OutputStream out) throws IOException {
        Object result = TemplateInterpreter.parse(template, ctx, tokens);
        if (result == null) {
            return;
        }
        CharSequence cs = result instanceof CharSequence ? (CharSequence)result : String.valueOf(result);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        int len = cs.length();
        int i = 0;
        while (i < len) {
            writer.write(cs.charAt(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static Object parse(File file, Object ctx, Map tokens) throws IOException {
        return TemplateInterpreter.parse(file, ctx, tokens, null);
    }

    public static Object parse(File file, Object ctx, Map tokens, TemplateRegistry registry) throws IOException {
        if (!file.exists()) {
            throw new CompileException("cannot find file: " + file.getName());
        }
        FileInputStream inStream = null;
        FileChannel fc = null;
        try {
            inStream = new FileInputStream(file);
            fc = inStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender sb = new StringAppender((int)file.length());
            int read = 0;
            while (read >= 0) {
                buf.rewind();
                read = fc.read(buf);
                buf.rewind();
                while (read > 0) {
                    sb.append((char)buf.get());
                    --read;
                }
            }
            Object object = TemplateInterpreter.parse(sb, ctx, tokens, registry);
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        return null;
    }

    public static Object parse(CharSequence expression, Object ctx, Map vars) {
        return TemplateInterpreter.parse(expression, ctx, vars, null);
    }

    public static Object parse(CharSequence expression, Object ctx, Map vars, TemplateRegistry registry) {
        if (expression == null) {
            return null;
        }
        return new TemplateInterpreter(expression).execute(ctx, vars, registry);
    }

    public static Object parse(String expression, Object ctx, Map vars) {
        return TemplateInterpreter.parse(expression, ctx, vars, null);
    }

    public static Object parse(String expression, Object ctx, Map vars, TemplateRegistry registry) {
        if (expression == null) {
            return null;
        }
        return new TemplateInterpreter(expression).execute(ctx, vars, registry);
    }

    public Object execute(Object ctx, Map tokens) {
        return this.execute(ctx, tokens, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object execute(Object ctx, Map tokens, TemplateRegistry registry) {
        if (this.nodes == null) {
            return new String(this.expression);
        }
        if (this.nodes.length == 2) {
            switch (this.nodes[0].getToken()) {
                case 5: {
                    if (TemplateInterpreter.CACHE_DISABLE || !TemplateInterpreter.cacheAggressively) {
                        seg = new char[this.expression.length - 3];
                        i = 0;
                        while (i < seg.length) {
                            seg[i] = this.expression[i + 2];
                            ++i;
                        }
                        return MVEL.eval(seg, ctx, (Map)tokens);
                    }
                    s = new String(this.expression, 2, this.expression.length - 3);
                    if (!TemplateInterpreter.EX_PRECOMP_CACHE.containsKey(s)) {
                        i = TemplateInterpreter.EX_PRECOMP_CACHE;
                        synchronized (i) {
                            TemplateInterpreter.EX_PRECOMP_CACHE.put(s, MVEL.compileExpression(s));
                            return MVEL.executeExpression((Object)TemplateInterpreter.EX_PRECOMP_CACHE.get(s), ctx, tokens);
                        }
                    }
                    return MVEL.executeExpression((Object)TemplateInterpreter.EX_PRECOMP_CACHE.get(s), ctx, tokens);
                }
                case 6: {
                    return new String(this.expression);
                }
            }
            return new String(this.expression);
        }
        register = null;
        sbuf = new StringAppender(10);
        currNode = null;
        try {
            oParser = new MVELInterpretedRuntime(ctx, (Map<String, Object>)tokens);
            this.initStack();
            this.pushAndForward();
            block26: while ((currNode = this.pop()) != null) {
                this.node = currNode.getNode();
                switch (currNode.getToken()) {
                    case 6: {
                        register = new String(this.expression, currNode.getStartPos(), currNode.getEndPos() - currNode.getStartPos());
                        sbuf.append(register);
                        ** GOTO lbl139
                    }
                    case 5: {
                        register = oParser.setExpressionArray(this.getInternalSegment(currNode)).parse();
                        sbuf.append(String.valueOf(register));
                        ** GOTO lbl139
                    }
                    case 0: 
                    case 2: {
                        try {
                            if (!((Boolean)oParser.setExpressionArray(this.getInternalSegment(currNode)).parse()).booleanValue()) {
                                this.exitContext();
                            }
                            ** GOTO lbl139
                        }
                        catch (ClassCastException e) {
                            throw new CompileException("IF expression does not return a boolean: " + new String(this.getSegment(currNode)));
                        }
                    }
                    case 1: {
                        if (tokens == null) {
                            tokens = new HashMap<String, Object>();
                        }
                        if (!(this.localStack.peek() instanceof ForeachContext)) {
                            foreachContext = ((ForeachContext)currNode.getRegister()).clone();
                            names = foreachContext.getNames();
                            aliases = foreachContext.getAliases();
                            try {
                                iters = new Iterator[names.length];
                                i = 0;
                                while (i < names.length) {
                                    listObject = new MVELInterpretedRuntime(names[i], ctx, tokens).parse();
                                    if (listObject instanceof Object[]) {
                                        listObject = Arrays.asList((Object[])listObject);
                                    }
                                    iters[i] = ((Collection)listObject).iterator();
                                    ++i;
                                }
                                foreachContext.setIterators(iters);
                                this.localStack.push(foreachContext);
                            }
                            catch (ClassCastException e) {
                                throw new CompileException("expression for collections does not return a collections object: " + new String(this.getSegment(currNode)), e);
                            }
                            catch (NullPointerException e) {
                                throw new CompileException("null returned for foreach in expression: " + this.getForEachSegment(currNode), e);
                            }
                        } else {
                            foreachContext = (ForeachContext)this.localStack.peek();
                            aliases = foreachContext.getAliases();
                        }
                        iters = foreachContext.getItererators();
                        if (iters[0].hasNext()) {
                            this.push();
                            i = 0;
                            while (i < iters.length) {
                                tokens.put(aliases[i], iters[i].next());
                                ++i;
                            }
                            c = foreachContext.getCount();
                            tokens.put("i0", new Integer(c));
                            if (c != 0) {
                                sbuf.append(foreachContext.getSeperator());
                            }
                            foreachContext.incrementCount();
                        } else {
                            i = 0;
                            while (i < iters.length) {
                                tokens.remove(aliases[i]);
                                ++i;
                            }
                            this.localStack.pop();
                            this.exitContext();
                        }
                        ** GOTO lbl139
                    }
                    case 3: 
                    case 4: {
                        if (!this.stack.isEmpty()) continue block26;
                        this.forwardAndPush();
                        break;
                    }
                    case 8: {
                        this.pushNode(currNode.getEndNode());
                        break;
                    }
                    case 7: {
                        if (this.nodes.length != 2) {
                            return sbuf.toString();
                        }
                        return register;
                    }
                    case 10: {
                        includeRef = (TemplateCompiler.IncludeRef)this.nodes[this.node].getRegister();
                        params = includeRef.getParams();
                        vars = new HashMap<String, Object>(params.length * 2);
                        var14_24 = params;
                        var13_23 = params.length;
                        var12_21 = 0;
                        while (var12_21 < var13_23) {
                            param = var14_24[var12_21];
                            vars.put(param.getIdentifier(), MVEL.eval(param.getValue(), ctx, tokens));
                            ++var12_21;
                        }
                        if (registry == null) {
                            throw new CompileException("No TemplateRegistry specified, cannot load template='" + includeRef.getName() + "'");
                        }
                        template = registry.getTemplate(includeRef.getName());
                        if (template == null) {
                            throw new CompileException("Template does not exist in the TemplateRegistry, cannot load template='" + includeRef.getName() + "'");
                        }
                        sbuf.append(TemplateInterpreter.parse(template, ctx, vars, registry));
                    }
lbl139:
                    // 7 sources

                    default: {
                        this.forwardAndPush();
                    }
                }
            }
            throw new CompileException("expression did not end properly: expected TERMINUS node");
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            if (currNode != null) {
                throw new CompileException("problem encountered at node [" + currNode.getNode() + "] " + currNode.getToken() + "{" + currNode.getStartPos() + "," + currNode.getEndPos() + "}: " + e.getMessage(), e);
            }
            throw new CompileException("unhandled fatal exception (node:" + this.node + ")", e);
        }
    }

    private void initStack() {
        this.stack = new ExecutionStack();
        this.localStack = new ExecutionStack();
    }

    private void push() {
        this.push(this.nodes[this.node]);
    }

    private void push(Node node) {
        if (node == null) {
            return;
        }
        this.stack.push(node);
    }

    private void pushNode(int i) {
        this.stack.push(this.nodes[i]);
    }

    private void exitContext() {
        this.node = this.nodes[this.node].getEndNode() - 1;
    }

    public void forwardAndPush() {
        ++this.node;
        this.push();
    }

    private void pushAndForward() {
        this.push();
        ++this.node;
    }

    private Node pop() {
        return (Node)this.stack.pop();
    }

    public static Object getValuePE(String expression, Object ctx, Map tokens) {
        return new TemplateInterpreter(expression).execute(ctx, tokens);
    }

    public static void setValuePE(String expression, Object ctx, Object preParseCx, Object value) {
        PropertyAccessor.set(ctx, String.valueOf(TemplateInterpreter.eval(expression, preParseCx)), value);
    }

    public char[] getExpression() {
        return this.expression;
    }

    public void setExpression(char[] expression) {
        this.expression = expression;
    }

    private char[] getSegment(Node n) {
        char[] ca = new char[n.getLength()];
        int o0 = n.getStartPos();
        int i = 0;
        while (i < ca.length) {
            ca[i] = this.expression[i + o0];
            ++i;
        }
        return ca;
    }

    private char[] getInternalSegment(Node n) {
        int start = n.getStartPos();
        int depth = 1;
        while (this.expression[start++] != '{') {
        }
        int end = start;
        while (depth > 0) {
            switch (this.expression[++end]) {
                case '}': {
                    --depth;
                    break;
                }
                case '{': {
                    ++depth;
                }
            }
        }
        char[] ca = new char[end - start];
        int i = 0;
        while (i < ca.length) {
            ca[i] = this.expression[i + start];
            ++i;
        }
        return ca;
    }

    private String getForEachSegment(Node n) {
        if (n.getAlias() == null) {
            return new String(this.getInternalSegment(n));
        }
        return n.getName();
    }

    public static boolean isCacheAggressively() {
        return cacheAggressively;
    }

    public static void setCacheAggressively(boolean cacheAggressively) {
        TemplateInterpreter.cacheAggressively = cacheAggressively;
    }

    public static void setDisableCache(boolean disableCache) {
        CACHE_DISABLE = disableCache;
    }
}

