/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import org.mvel.ASTIterator;
import org.mvel.ASTLinkedList;
import org.mvel.ExecutableStatement;
import org.mvel.MVELRuntime;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledExpression
implements Serializable,
ExecutableStatement {
    private ASTIterator tokens;
    private Class knownEgressType;
    private Class knownIngressType;
    private boolean convertableIngressEgress;
    private boolean optimized = false;
    private boolean importInjectionRequired = false;
    private boolean returnBigDecimal = false;
    private boolean literalOnly;
    private Class<? extends AccessorOptimizer> accessorOptimizer;
    private String sourceName;
    private ParserContext parserContext;

    public CompiledExpression(ASTIterator astMap, String sourceName, Class egressType, ParserContext ctx, boolean literalOnly) {
        this.tokens = astMap;
        this.sourceName = sourceName;
        this.knownEgressType = egressType;
        this.literalOnly = literalOnly;
        this.setParserContext(ctx);
    }

    public CompiledExpression(ASTIterator astMap, String sourceName, boolean literalOnly) {
        this.tokens = astMap;
        this.sourceName = sourceName;
        this.literalOnly = literalOnly;
    }

    public ASTIterator getTokens() {
        return new ASTLinkedList(this.tokens.firstNode(), this.tokens.size());
    }

    public void setTokens(ASTIterator tokens) {
        this.tokens = tokens;
    }

    @Override
    public Class getKnownEgressType() {
        return this.knownEgressType;
    }

    @Override
    public void setKnownEgressType(Class knownEgressType) {
        this.knownEgressType = knownEgressType;
    }

    @Override
    public Class getKnownIngressType() {
        return this.knownIngressType;
    }

    @Override
    public void setKnownIngressType(Class knownIngressType) {
        this.knownIngressType = knownIngressType;
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return this.convertableIngressEgress;
    }

    public void setConvertableIngressEgress(boolean convertableIngressEgress) {
        this.convertableIngressEgress = convertableIngressEgress;
    }

    @Override
    public void computeTypeConversionRule() {
        if (this.knownIngressType != null && this.knownEgressType != null) {
            this.convertableIngressEgress = this.knownIngressType.isAssignableFrom(this.knownEgressType);
        }
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.optimized) {
            this.setupOptimizers();
        }
        return this.getValue(ctx, variableFactory);
    }

    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        if (!this.optimized) {
            this.setupOptimizers();
        }
        return ParseTools.handleParserEgress(MVELRuntime.execute(false, this, staticContext, factory), this.returnBigDecimal);
    }

    public Object getDirectValue(Object staticContext, VariableResolverFactory factory) {
        return MVELRuntime.execute(false, this, staticContext, factory);
    }

    private void setupOptimizers() {
        OptimizerFactory.setThreadAccessorOptimizer(this.accessorOptimizer);
        this.optimized = true;
    }

    public ASTIterator getTokenIterator() {
        return this.tokens;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public Class<? extends AccessorOptimizer> getAccessorOptimizer() {
        return this.accessorOptimizer;
    }

    public void setAccessorOptimizer(Class<? extends AccessorOptimizer> accessorOptimizer) {
        this.accessorOptimizer = accessorOptimizer;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public boolean intOptimized() {
        return false;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
        if (this.parserContext != null) {
            this.importInjectionRequired = parserContext.getImports() != null && parserContext.getImports().size() != 0;
        }
    }

    public boolean isReturnBigDecimal() {
        return this.returnBigDecimal;
    }

    public void setReturnBigDecimal(boolean returnBigDecimal) {
        this.returnBigDecimal = returnBigDecimal;
    }

    public boolean isImportInjectionRequired() {
        return this.importInjectionRequired;
    }

    public void setImportInjectionRequired(boolean importInjectionRequired) {
        this.importInjectionRequired = importInjectionRequired;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    @Override
    public boolean isLiteralOnly() {
        return this.literalOnly;
    }
}

