/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.property.Math;
import net.sf.antcontrib.property.Num;
import org.apache.tools.ant.BuildException;

public class Op {
    private String datatype = null;
    Vector nums = new Vector();
    Vector ops = new Vector();
    String operation = null;
    private boolean _strict = false;

    public void setOp(String op) {
        this.operation = op.equals("+") ? "add" : (op.equals("-") ? "subtract" : (op.equals("*") ? "multiply" : (op.equals("/") ? "divide" : (op.equals("%") ? "mod" : op))));
    }

    public void addNum(Num num) {
        this.nums.addElement(num);
    }

    public void setDatatype(String p) {
        if (!(p.equals("int") || p.equals("long") || p.equals("float") || p.equals("double"))) {
            throw new BuildException("Invalid datatype: " + p + ". Must be one of int, long, float, or double.");
        }
        this.datatype = p;
    }

    public void addConfiguredOp(Op op) {
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.ops.addElement(op);
    }

    public void setStrict(boolean b) {
        this._strict = b;
    }

    public Num calculate() {
        if (this.operation == null) {
            throw new BuildException("Operation not specified.");
        }
        Enumeration e = this.ops.elements();
        while (e.hasMoreElements()) {
            Op op = (Op)e.nextElement();
            if (this.datatype != null) {
                op.setDatatype(this.datatype);
            }
            this.nums.addElement(op.calculate());
        }
        String[] operands = new String[this.nums.size()];
        e = this.nums.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Num num = (Num)e.nextElement();
            if (this.datatype != null) {
                num.setDatatype(this.datatype);
            }
            operands[i++] = num.toString();
        }
        Math math = new Math(this._strict);
        Number number = math.calculate(this.operation, this.datatype, operands);
        Num num = new Num();
        num.setValue(number.toString());
        num.setDatatype(this.datatype);
        return num;
    }
}

