/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortComponentResolver
implements EndpointResolver {
    private static final Logger log = Logger.getLogger(PortComponentResolver.class);
    private String pcLink;
    private Endpoint result;

    public PortComponentResolver(String pcref) {
        this.pcLink = pcref;
    }

    @Override
    public Endpoint query(Iterator<Endpoint> endpoints) {
        Endpoint endpoint = null;
        String pcName = this.pcLink;
        int hashIndex = this.pcLink.indexOf("#");
        if (hashIndex > 0) {
            pcName = this.pcLink.substring(hashIndex + 1);
        }
        while (endpoints.hasNext()) {
            Endpoint auxEndpoint = endpoints.next();
            ServerEndpointMetaData sepMetaData = auxEndpoint.getAttachment(ServerEndpointMetaData.class);
            if (!pcName.equals(sepMetaData.getPortComponentName())) continue;
            if (endpoint != null) {
                log.warn((Object)("Multiple service endoints found for: " + this.pcLink));
                endpoint = null;
                break;
            }
            endpoint = auxEndpoint;
        }
        return endpoint;
    }
}

