/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Observable;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.jaxrpc.SOAP11BindingJAXRPC;
import org.jboss.ws.core.jaxrpc.SOAP12BindingJAXRPC;
import org.jboss.ws.core.jaxws.binding.HTTPBindingJAXWS;
import org.jboss.ws.core.jaxws.binding.SOAP11BindingJAXWS;
import org.jboss.ws.core.jaxws.binding.SOAP12BindingJAXWS;
import org.jboss.ws.metadata.config.Configurable;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class CommonBindingProvider
implements Configurable {
    private static Logger log = Logger.getLogger(CommonBindingProvider.class);
    protected EndpointMetaData epMetaData;
    protected CommonBinding binding;

    public CommonBindingProvider(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
        this.initBinding(epMetaData.getBindingId(), epMetaData.getType());
        this.epMetaData.registerConfigObserver(this);
        this.configure();
    }

    public CommonBindingProvider(String bindingId, EndpointMetaData.Type type) {
        this.initBinding(bindingId, type);
        this.configure();
    }

    private void configure() {
        if (this.epMetaData != null) {
            this.epMetaData.configure(this);
        }
    }

    protected void initBinding(String bindingId, EndpointMetaData.Type type) {
        if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingId)) {
            this.binding = type == EndpointMetaData.Type.JAXWS ? new SOAP11BindingJAXWS() : new SOAP11BindingJAXRPC();
        } else if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingId)) {
            this.binding = type == EndpointMetaData.Type.JAXWS ? new SOAP11BindingJAXWS(true) : new SOAP11BindingJAXRPC(true);
        } else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId)) {
            this.binding = type == EndpointMetaData.Type.JAXWS ? new SOAP12BindingJAXWS() : new SOAP12BindingJAXRPC();
        } else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingId)) {
            this.binding = type == EndpointMetaData.Type.JAXWS ? new SOAP12BindingJAXWS(true) : new SOAP12BindingJAXRPC(true);
        } else if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingId)) {
            this.binding = new HTTPBindingJAXWS();
        }
    }

    public CommonBinding getCommonBinding() {
        return this.binding;
    }

    public void update(Observable observable, Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update config: " + object));
        }
        this.configure();
    }
}

