/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.saxon8;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.StyleElement;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.w3c.dom.Node;

public class BarcodeStyleElement
extends StyleElement {
    private Expression message;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String msgAtt = this.attributeList.getValue("message");
        if (msgAtt == null) {
            this.reportAbsence("message");
        }
        this.message = this.makeAttributeValueTemplate(msgAtt);
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.message = this.typeCheck("message", this.message);
    }

    public Instruction compile(Executable exec) throws TransformerConfigurationException {
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)((Object)this));
        BarcodeInstruction inst = new BarcodeInstruction(this.message, cfg);
        return inst;
    }

    private static class BarcodeInstruction
    extends Instruction {
        private Expression message;
        private Configuration cfg;

        public BarcodeInstruction(Expression message, Configuration cfg) {
            this.message = message;
            this.cfg = cfg;
        }

        public String getInstructionName() {
            return "barcode";
        }

        public TailCall processLeavingTail(XPathContext context) throws TransformerException {
            Controller controller = context.getController();
            String effMessage = this.message.evaluateAsString(context);
            try {
                SequenceReceiver out = controller.getReceiver();
                BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator(this.cfg);
                SVGCanvasProvider svg = this.cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(this.cfg.getAttribute("prefix", "svg")) : new SVGCanvasProvider(false);
                gen.generateBarcode(svg, effMessage);
                DocumentWrapper wrapper = new DocumentWrapper(svg.getDOM(), "http://www.w3.org/2000/svg");
                out.append((Item)wrapper);
            }
            catch (ConfigurationException ce) {
                throw new TransformerException("(Barcode4J) " + ce.getMessage());
            }
            catch (BarcodeException be) {
                throw new TransformerException("(Barcode4J) " + be.getMessage());
            }
            return null;
        }
    }
}

