/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.bitmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.output.AbstractCanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapBuilder;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;

public class BitmapCanvasProvider
extends AbstractCanvasProvider {
    private OutputStream out;
    private String mime;
    private int resolution;
    private int imageType;
    private boolean antiAlias;
    private BufferedImage image;
    private Java2DCanvasProvider delegate;

    public BitmapCanvasProvider(OutputStream out, String mime, int resolution, int imageType, boolean antiAlias) {
        this.out = out;
        this.mime = mime;
        this.resolution = resolution;
        this.imageType = imageType;
        this.antiAlias = antiAlias;
    }

    public BitmapCanvasProvider(int resolution, int imageType, boolean antiAlias) {
        this(null, null, resolution, imageType, antiAlias);
    }

    public void finish() throws IOException {
        this.image.flush();
        if (this.out != null) {
            BitmapEncoder encoder = BitmapEncoderRegistry.getInstance(this.mime);
            encoder.encode(this.image, this.out, this.mime, this.resolution);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        this.image = BitmapBuilder.prepareImage(dim, this.resolution, this.imageType);
        this.delegate = new Java2DCanvasProvider(BitmapBuilder.prepareGraphics2D(this.image, dim, this.antiAlias));
        this.delegate.establishDimensions(dim);
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        this.delegate.deviceFillRect(x, y, w, h);
    }

    public void deviceJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.delegate.deviceJustifiedText(text, x1, x2, y1, fontName, fontSize);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.delegate.deviceCenteredText(text, x1, x2, y1, fontName, fontSize);
    }
}

