/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BaselineAlignment;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.DrawingUtil;
import org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import org.krysalis.barcode4j.output.Canvas;

public class DefaultHeightVariableLogicHandler
implements ClassicBarcodeLogicHandler {
    private HeightVariableBarcodeBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private String formattedMsg;

    public DefaultHeightVariableLogicHandler(HeightVariableBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = formattedMsg;
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void addBar(boolean black, int height) {
        double w = black ? this.bcBean.getBarWidth(1) : this.bcBean.getBarWidth(-1);
        double h = this.bcBean.getBarHeight(height);
        BaselineAlignment baselinePosition = this.bcBean.getBaselinePosition();
        if (black) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                    this.canvas.drawRectWH(this.x, this.bcBean.getHumanReadableHeight(), w, h);
                } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                    this.canvas.drawRectWH(this.x, this.bcBean.getHeight() - h, w, h);
                }
            } else if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                this.canvas.drawRectWH(this.x, 0.0, w, h);
            } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                this.canvas.drawRectWH(this.x, this.bcBean.getBarHeight() - h, w, h);
            }
        }
        this.x += w;
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.bcBean.getHumanReadableHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.bcBean.getHeight());
            }
        }
    }

    public void startBarGroup(BarGroup barGroup, String string) {
    }

    public void endBarGroup() {
    }
}

