/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.Length;

public abstract class ConfigurableBarcodeGenerator
implements BarcodeGenerator,
Configurable {
    protected AbstractBarcodeBean bean;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length h = new Length(cfg.getChild("height").getValue("15mm"), "mm");
        this.getBean().setHeight(h.getValueAsMillimeter());
        this.getBean().doQuietZone(cfg.getChild("quiet-zone").getAttributeAsBoolean("enabled", true));
        Length qz = new Length(cfg.getChild("quiet-zone").getValue("10mw"), "mw");
        if (qz.getUnit().equalsIgnoreCase("mw")) {
            this.getBean().setQuietZone(qz.getValue() * this.getBean().getModuleWidth());
        } else {
            this.getBean().setQuietZone(qz.getValueAsMillimeter());
        }
        Configuration hr = cfg.getChild("human-readable", false);
        if (hr != null && hr.getChildren().length > 0) {
            this.getBean().setMsgPosition(HumanReadablePlacement.byName(hr.getChild("placement").getValue(HumanReadablePlacement.HRP_BOTTOM.getName())));
            Length fs = new Length(hr.getChild("font-size").getValue("8pt"));
            this.getBean().setFontSize(fs.getValueAsMillimeter());
            this.getBean().setFontName(hr.getChild("font-name").getValue("Helvetica"));
        } else {
            this.getBean().setMsgPosition(HumanReadablePlacement.byName(cfg.getChild("human-readable").getValue(HumanReadablePlacement.HRP_BOTTOM.getName())));
            Length fs = new Length(cfg.getChild("human-readable-size").getValue("8pt"));
            this.getBean().setFontSize(fs.getValueAsMillimeter());
            this.getBean().setFontName(cfg.getChild("human-readable-font").getValue("Helvetica"));
        }
    }

    public AbstractBarcodeBean getBean() {
        return this.bean;
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        this.getBean().generateBarcode(canvas, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        return this.getBean().calcDimensions(msg);
    }
}

