/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.comet;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkmax.ui.comet.CometAuWriter;
import org.zkoss.zkmax.ui.comet.CometProcessor;

public class CometServerPush
implements ServerPush {
    private static final Log log = Log.lookup((Class)CometServerPush.class);
    private static final int GIVEUP = -99;
    private Desktop _desktop;
    private final List _pending = new LinkedList();
    private ThreadInfo _active;
    private final Object _mutex = new Object();
    private ThreadInfo _ready;
    private boolean _busy;

    protected void startClientPush() {
        Clients.response((AuResponse)new AuScript(null, this.getStartScript()));
    }

    protected void stopClientPush() {
        Clients.response((AuResponse)new AuScript(null, this.getStopScript()));
    }

    protected String getStartScript() {
        String start = this._desktop.getWebApp().getConfiguration().getPreference("CometServerPush.start", null);
        if (start != null) {
            return start;
        }
        String dtid = this._desktop.getId();
        return "zk.invoke('zkmax.ui.cmsp',function(){zkCmsp.start('" + dtid + "');},'" + dtid + "');";
    }

    protected String getStopScript() {
        String stop = this._desktop.getWebApp().getConfiguration().getPreference("CometServerPush.stop", null);
        return stop != null ? stop : "zkCmsp.stop('" + this._desktop.getId() + "');";
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public boolean isActive() {
        return this._active != null;
    }

    public void start(Desktop desktop) {
        if (this._desktop != null) {
            log.warning("Ignored: Sever-push already started");
            return;
        }
        this._desktop = desktop;
        CometProcessor.init(this._desktop.getWebApp());
        this.startClientPush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean inexec;
        if (this._desktop == null) {
            log.warning("Ignored: Sever-push not started");
            return;
        }
        boolean bl = inexec = Executions.getCurrent() != null;
        if (inexec) {
            this.stopClientPush();
        }
        this._desktop = null;
        this.wakePending();
        if (!inexec) {
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakePending() {
        List list = this._pending;
        synchronized (list) {
            Iterator it = this._pending.iterator();
            while (it.hasNext()) {
                ThreadInfo info;
                ThreadInfo threadInfo = info = (ThreadInfo)it.next();
                synchronized (threadInfo) {
                    info.notify();
                }
            }
            this._pending.clear();
            this._pending.notify();
        }
    }

    public void setDelay(int min, int max, int factor) {
    }

    public void onPiggyback() {
    }

    synchronized boolean setBusy() {
        boolean old = this._busy;
        this._busy = true;
        return old;
    }

    /*
     * Exception decompiling
     */
    void process(Execution exec, CometAuWriter out) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        boolean loop;
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        ThreadInfo info = new ThreadInfo(curr);
        List list = this._pending;
        synchronized (list) {
            if (this._desktop != null) {
                if (this._ready != null) {
                    info = this._ready;
                    info.thread = curr;
                    this._ready = null;
                    this._pending.notify();
                } else {
                    this._pending.add(info);
                }
            }
        }
        do {
            loop = false;
            ThreadInfo threadInfo = info;
            synchronized (threadInfo) {
                if (this._desktop != null) {
                    if (info.nActive == 0) {
                        info.wait(timeout <= 0L ? 600000L : timeout);
                    }
                    if (info.nActive <= 0) {
                        boolean bDead;
                        boolean bTimeout = timeout > 0L;
                        boolean bl = bDead = this._desktop == null || !this._desktop.isAlive();
                        if (bTimeout || bDead) {
                            info.nActive = -99;
                            List list2 = this._pending;
                            synchronized (list2) {
                                this._pending.remove(info);
                            }
                            if (bDead) {
                                throw new DesktopUnavailableException("Stopped");
                            }
                            return false;
                        }
                        log.debug("Executions.activate() took more than 10 minutes");
                        loop = true;
                    }
                }
            }
        } while (loop);
        if (this._desktop == null) {
            throw new DesktopUnavailableException("Stopped");
        }
        this._active = info;
        ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().beginUpdate(this._active.exec);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (this._active.exec != null && this._active.out != null) {
                try {
                    if (stop) {
                        this.stopClientPush();
                    }
                    ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().endUpdate(this._active.exec, (AuWriter)this._active.out);
                }
                catch (Throwable ex) {
                    log.warningBriefly("Ignored error", ex);
                }
            }
            this._active.nActive = 0;
            this._active = null;
            if (stop) {
                this._desktop = null;
                this.wakePending();
                stopped = true;
            }
            Object object = this._mutex;
            synchronized (object) {
                this._busy = false;
                this._mutex.notify();
            }
        }
        return stopped;
    }

    private static class ThreadInfo {
        private Thread thread;
        private int nActive;
        private Execution exec;
        private CometAuWriter out;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        private void setActive(Execution exec, CometAuWriter out) {
            this.nActive = 1;
            this.exec = exec;
            this.out = out;
        }

        public String toString() {
            return "[" + this.thread + ',' + this.nActive + ']';
        }

        static /* synthetic */ void access$100(ThreadInfo x0, Execution x1, CometAuWriter x2) {
            x0.setActive(x1, x2);
        }

        static /* synthetic */ Execution access$302(ThreadInfo x0, Execution x1) {
            x0.exec = x1;
            return x0.exec;
        }

        static /* synthetic */ CometAuWriter access$402(ThreadInfo x0, CometAuWriter x1) {
            x0.out = x1;
            return x0.out;
        }
    }
}

