/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.ScalableTimer;
import org.zkoss.util.ScalableTimerTask;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.http.HttpAuWriter;

public class SmartAuWriter
extends HttpAuWriter {
    private static final Log log = Log.lookup((Class)SmartAuWriter.class);
    private static final byte[] CONTENT_HEAD_BYTES = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes();
    private static ScalableTimer _timer;
    private Task _tmoutTask;
    private boolean _timeout;

    public SmartAuWriter() {
        if (_timer == null) {
            _timer = this.newTimer();
        }
    }

    protected ScalableTimer newTimer() {
        return new ScalableTimer(50, 25);
    }

    public AuWriter open(Object request, Object response, int timeout) throws IOException {
        if (timeout > 0) {
            this._tmoutTask = new Task((HttpServletResponse)response);
            _timer.schedule((ScalableTimerTask)this._tmoutTask, (long)timeout);
        }
        return super.open(request, response, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean timeout;
        Task task = this._tmoutTask;
        if (task != null) {
            task.cancel();
        }
        SmartAuWriter smartAuWriter = this;
        synchronized (smartAuWriter) {
            this._tmoutTask = null;
            timeout = this._timeout;
            this._timeout = false;
        }
        if (timeout) {
            response.getOutputStream().write(this._out.getBuffer().substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".length()).getBytes("UTF-8"));
            response.flushBuffer();
        } else {
            super.flush(request, response);
        }
    }

    private class Task
    extends ScalableTimerTask {
        private final HttpServletResponse _res;

        private Task(HttpServletResponse response) {
            this._res = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exec() {
            SmartAuWriter smartAuWriter = SmartAuWriter.this;
            synchronized (smartAuWriter) {
                if (SmartAuWriter.this._tmoutTask != null) {
                    try {
                        this._res.getOutputStream().write(CONTENT_HEAD_BYTES);
                        SmartAuWriter.this._timeout = true;
                        this._res.flushBuffer();
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored: failed to send the head\n" + Exceptions.getMessage((Throwable)ex));
                    }
                    SmartAuWriter.this._tmoutTask = null;
                }
            }
        }
    }
}

