/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.SelectedItemConverter;
import org.zkoss.zkplus.databind.TypeConverter;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ListModel;

public class SelectedComboitemConverter
implements TypeConverter,
Serializable {
    private static final long serialVersionUID = 200808191437L;

    public Object coerceToBean(Object val, Component comp) {
        Combobox cbbox = (Combobox)comp;
        if (Executions.getCurrent().getAttribute("zkoss.zkplus.databind.ON_SELECT" + cbbox.getUuid()) != null) {
            Executions.getCurrent().removeAttribute("zkoss.zkplus.databind.ON_SELECT" + cbbox.getUuid());
            return TypeConverter.IGNORE;
        }
        if (val != null) {
            ListModel model = cbbox.getModel();
            return model != null ? model.getElementAt(cbbox.getItems().indexOf(val)) : ((Comboitem)val).getValue();
        }
        return null;
    }

    public Object coerceToUi(Object val, Component comp) {
        Combobox cbbox = (Combobox)comp;
        if (val != null) {
            ListModel xmodel = cbbox.getModel();
            if (xmodel instanceof BindingListModel) {
                if (cbbox.getAttribute("zul.Combobox.ON_INITRENDER") != null) {
                    return TypeConverter.IGNORE;
                }
                BindingListModel model = (BindingListModel)xmodel;
                int index = model.indexOf(val);
                if (index >= 0 && cbbox.getItemCount() > index) {
                    Comboitem item = cbbox.getItemAtIndex(index);
                    if (SelectedItemConverter.isOnSelectWhenLoad()) {
                        int selIndex = cbbox.getSelectedIndex();
                        if (item != null && selIndex != index) {
                            HashSet<Comboitem> items = new HashSet<Comboitem>();
                            items.add(item);
                            Executions.getCurrent().setAttribute("zkoss.zkplus.databind.ON_SELECT" + cbbox.getUuid(), (Object)Boolean.TRUE);
                            Events.postEvent((Event)new SelectEvent("onSelect", (Component)cbbox, items, (Component)item));
                        }
                    }
                    return item;
                }
            } else if (xmodel == null) {
                Iterator it = cbbox.getItems().iterator();
                while (it.hasNext()) {
                    Comboitem li = (Comboitem)it.next();
                    if (!val.equals(li.getValue())) continue;
                    return li;
                }
            } else {
                throw new UiException("model of the databind combobox " + cbbox + " must be an instanceof of org.zkoss.zkplus.databind.BindingListModel." + xmodel);
            }
        }
        return null;
    }
}

