/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import org.zkoss.lang.Objects;

public class JavaScript {
    private final String _src;
    private final String _charset;
    private final String _content;

    public JavaScript(String src, String charset) {
        if (src == null) {
            throw new IllegalArgumentException("null src");
        }
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        this._src = src;
        this._charset = charset;
        this._content = null;
    }

    public JavaScript(String content) {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        this._charset = null;
        this._src = null;
        this._content = content;
    }

    public String getSrc() {
        return this._src;
    }

    public String getCharset() {
        return this._charset;
    }

    public String getContent() {
        return this._content;
    }

    public String toString() {
        return "[src: " + this._src + " charset=" + this._charset + ']';
    }

    public int hashCode() {
        return Objects.hashCode((Object)this._src) + Objects.hashCode((Object)this._content);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaScript)) {
            return false;
        }
        JavaScript js = (JavaScript)o;
        return Objects.equals((Object)js._src, (Object)this._src) && Objects.equals((Object)js._charset, (Object)this._charset) && Objects.equals((Object)js._content, (Object)this._content);
    }
}

