/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.localization;

import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.localization.I18nResourceProvider;
import org.displaytag.localization.LocaleResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class I18nSpringAdapter
implements LocaleResolver,
I18nResourceProvider {
    public static final String UNDEFINED_KEY = "???";
    private static Log log = LogFactory.getLog((Class)I18nSpringAdapter.class);

    public Locale resolveLocale(HttpServletRequest request) {
        return RequestContextUtils.getLocale((HttpServletRequest)request);
    }

    public String getResource(String resourceKey, String defaultValue, Tag tag, PageContext pageContext) {
        WebApplicationContext messageSource = RequestContextUtils.getWebApplicationContext((ServletRequest)pageContext.getRequest());
        if (messageSource == null) {
            log.warn((Object)"messageSource not found");
            return null;
        }
        String key = resourceKey != null ? resourceKey : defaultValue;
        String message = null;
        message = messageSource.getMessage(key, null, null, RequestContextUtils.getLocale((HttpServletRequest)((HttpServletRequest)pageContext.getRequest())));
        if (message == null && resourceKey != null) {
            log.debug((Object)Messages.getString("Localization.missingkey", resourceKey));
            message = UNDEFINED_KEY + resourceKey + UNDEFINED_KEY;
        }
        return message;
    }
}

