/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.export.TextExportView;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;

public abstract class BaseExportView
implements TextExportView {
    private static Log log = LogFactory.getLog(BaseExportView.class);
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;

    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    protected String getRowStart() {
        return null;
    }

    protected String getRowEnd() {
        return null;
    }

    protected String getCellStart() {
        return null;
    }

    protected abstract String getCellEnd();

    protected String getDocumentStart() {
        return null;
    }

    protected String getDocumentEnd() {
        return null;
    }

    protected abstract boolean getAlwaysAppendCellEnd();

    protected abstract boolean getAlwaysAppendRowEnd();

    protected abstract String escapeColumnValue(Object var1);

    protected String doHeaders() {
        String ROW_START = this.getRowStart();
        String ROW_END = this.getRowEnd();
        String CELL_START = this.getCellStart();
        String CELL_END = this.getCellEnd();
        boolean ALWAYS_APPEND_CELL_END = this.getAlwaysAppendCellEnd();
        StringBuffer buffer = new StringBuffer(1000);
        Iterator iterator = this.model.getHeaderCellList().iterator();
        if (ROW_START != null) {
            buffer.append(ROW_START);
        }
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            columnHeader = this.escapeColumnValue(columnHeader);
            if (CELL_START != null) {
                buffer.append(CELL_START);
            }
            if (columnHeader != null) {
                buffer.append(columnHeader);
            }
            if (CELL_END == null || !ALWAYS_APPEND_CELL_END && !iterator.hasNext()) continue;
            buffer.append(CELL_END);
        }
        if (ROW_END != null) {
            buffer.append(ROW_END);
        }
        return buffer.toString();
    }

    public void doExport(Writer out) throws IOException, JspException {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getClass().getName());
        }
        String DOCUMENT_START = this.getDocumentStart();
        String DOCUMENT_END = this.getDocumentEnd();
        String ROW_START = this.getRowStart();
        String ROW_END = this.getRowEnd();
        String CELL_START = this.getCellStart();
        String CELL_END = this.getCellEnd();
        boolean ALWAYS_APPEND_CELL_END = this.getAlwaysAppendCellEnd();
        boolean ALWAYS_APPEND_ROW_END = this.getAlwaysAppendRowEnd();
        this.write(out, DOCUMENT_START);
        if (this.header) {
            this.write(out, this.doHeaders());
        }
        RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            if (this.model.getTableDecorator() != null) {
                String stringStartRow = this.model.getTableDecorator().startRow();
                this.write(out, stringStartRow);
            }
            ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
            this.write(out, ROW_START);
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                String value = this.escapeColumnValue(column.getValue(this.decorated));
                value = BaseExportView.parseValue(value);
                this.write(out, CELL_START);
                this.write(out, value);
                if (!ALWAYS_APPEND_CELL_END && !columnIterator.hasNext()) continue;
                this.write(out, CELL_END);
            }
            if (!ALWAYS_APPEND_ROW_END && !rowIterator.hasNext()) continue;
            this.write(out, ROW_END);
        }
        this.write(out, DOCUMENT_END);
    }

    protected static String parseValue(String value) {
        try {
            int beginIndex = value.indexOf(">");
            String subString = value.substring(beginIndex, value.length());
            int endIndex = subString.indexOf("<");
            return value.substring(beginIndex + 1, beginIndex + endIndex);
        }
        catch (Exception exception) {
            return value;
        }
    }

    private void write(Writer out, String string) throws IOException {
        if (string != null) {
            out.write(string);
        }
    }

    public boolean outputPage() {
        return false;
    }
}

