/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Errorable;
import org.zkoss.zk.ui.ext.client.InputableX;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ClientConstraint;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.CustomConstraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public abstract class InputElement
extends XulElement
implements Constrainted,
org.zkoss.zul.impl.api.InputElement {
    private static final Log log = Log.lookup((Class)InputElement.class);
    private Object _value;
    private transient String _txtByClient;
    private String _errmsg;
    private String _name;
    private int _maxlength;
    private int _cols;
    private int _tabindex = -1;
    private Constraint _constr;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _valided;
    private transient boolean _checkOnly;

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readOnly", this._readonly);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getErrorMessage() {
        return this._errmsg;
    }

    public void clearErrorMessage(boolean revalidateRequired) {
        if (this._errmsg != null) {
            this._errmsg = null;
            Clients.closeErrorBox((Component)this);
        }
        this._valided = !revalidateRequired;
    }

    public void clearErrorMessage() {
        this.clearErrorMessage(false);
    }

    public String getText() throws WrongValueException {
        this.checkUserError();
        return this.coerceToString(this._value);
    }

    public void setText(String value) throws WrongValueException {
        if (this._maxlength > 0 && value != null && value.length() > this._maxlength) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._maxlength)));
        }
        Object val = this.coerceFromString(value);
        this.validate(val);
        boolean errFound = this._errmsg != null;
        this.clearErrorMessage();
        if (!Objects.equals((Object)this._value, (Object)val)) {
            this._value = val;
            String fmtval = this.coerceToString(this._value);
            if (this._txtByClient == null || !Objects.equals((Object)this._txtByClient, (Object)fmtval)) {
                this._txtByClient = null;
                this.smartUpdate("value", fmtval);
            }
        } else if (this._txtByClient != null) {
            String fmtval = this.coerceToString(this._value);
            if (!Objects.equals((Object)this._txtByClient, (Object)fmtval)) {
                this._txtByClient = null;
                this.smartUpdate("value", fmtval);
            }
        } else if (errFound) {
            this.smartUpdate("value", this.coerceToString(this._value));
        }
    }

    protected abstract Object coerceFromString(String var1) throws WrongValueException;

    protected abstract String coerceToString(Object var1);

    protected void validate(Object value) throws WrongValueException {
        Constraint constr = this.getConstraint();
        if (constr != null) {
            Namespaces.beforeInterpret((Component)this);
            try {
                constr.validate((Component)this, value);
                if (!this._checkOnly && constr instanceof CustomConstraint) {
                    try {
                        ((CustomConstraint)((Object)constr)).showCustomError((Component)this, null);
                    }
                    catch (Throwable ex) {
                        log.realCauseBriefly(ex);
                    }
                }
            }
            catch (WrongValueException ex) {
                if (!this._checkOnly && constr instanceof CustomConstraint) {
                    ((CustomConstraint)((Object)constr)).showCustomError((Component)this, ex);
                }
                throw ex;
            }
            finally {
                Namespaces.afterInterpret();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WrongValueException showCustomError(WrongValueException ex) {
        if (this._constr instanceof CustomConstraint) {
            Namespaces.beforeInterpret((Component)this);
            try {
                ((CustomConstraint)((Object)this._constr)).showCustomError((Component)this, ex);
            }
            catch (Throwable t) {
                log.realCause(t);
            }
            finally {
                Namespaces.afterInterpret();
            }
        }
        return ex;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.invalidate();
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) throws WrongValueException {
        if (cols <= 0) {
            throw new WrongValueException("Illegal cols: " + cols);
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.smartUpdate("cols", Integer.toString(this._cols));
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public boolean isMultiline() {
        return false;
    }

    public String getType() {
        return "text";
    }

    public void select() {
        this.response("setAttr", (AuResponse)new AuSetAttribute((Component)this, "z.sel", "all"));
    }

    protected boolean shallServerFormat() {
        return false;
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? SimpleConstraint.getInstance(constr) : null);
    }

    public void setConstraint(Constraint constr) {
        if (!Objects.equals((Object)this._constr, (Object)constr)) {
            this._constr = constr;
            this._valided = false;
            this.invalidate();
        }
    }

    public final Constraint getConstraint() {
        return this._constr;
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        if (this.isMultiline()) {
            if (this._cols > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"cols", (int)this._cols);
            }
            if (this._maxlength > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.maxlen", (int)this._maxlength);
            }
        } else {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)this.coerceToString(this._value));
            if (this._cols > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"size", (int)this._cols);
            }
            if (this._maxlength > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"maxlength", (int)this._maxlength);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"type", (String)("password".equals(this.getType()) ? "password" : "text"));
        }
        if (this._tabindex >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
        }
        if (this.isReadonly()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"readonly", (String)"readonly");
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onChange");
        this.appendAsapAttr(sb, "onChanging");
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        this.appendAsapAttr(sb, "onSelection");
        String serverValid = null;
        if (this._constr != null) {
            if (this._constr instanceof CustomConstraint) {
                serverValid = "custom";
            } else if (this._constr instanceof ClientConstraint) {
                ClientConstraint cc = (ClientConstraint)((Object)this._constr);
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valid", (String)this.toJavaScript(cc.getClientValidation()));
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ermg", (String)cc.getErrorMessage((Component)this));
                if (!cc.isClientComplete()) {
                    serverValid = "both";
                }
            } else {
                serverValid = "both";
            }
        }
        if (serverValid == null && this.shallServerFormat()) {
            serverValid = "fmt";
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.srvald", (String)serverValid);
        return sb.toString();
    }

    private final String toJavaScript(String script) {
        return script != null ? (script.indexOf(40) >= 0 ? ComponentsCtrl.parseClientScript((Component)this, (String)script) : script) : null;
    }

    protected Object getTargetValue() throws WrongValueException {
        this.checkUserError();
        return this._value;
    }

    public Object getRawValue() {
        return this._value;
    }

    public String getRawText() {
        return this.coerceToString(this._value);
    }

    public void setRawValue(Object value) {
        if (this._errmsg != null || !Objects.equals((Object)this._value, (Object)value)) {
            this.clearErrorMessage(true);
            this._value = value;
            this.smartUpdate("value", this.coerceToString(this._value));
        }
    }

    protected void setValueDirectly(Object value) {
        this._value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this._errmsg != null) {
            return false;
        }
        if (!this._valided && this._constr != null) {
            this._checkOnly = true;
            try {
                this.validate(this._value);
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                this._checkOnly = false;
            }
        }
        return true;
    }

    public void setSelectedText(int start, int end, String newtxt, boolean isHighLight) {
        if (start <= end) {
            String txt = this.getText();
            int len = txt.length();
            if (start < 0) {
                start = 0;
            }
            if (start > len) {
                start = len;
            }
            if (end < 0) {
                end = 0;
            }
            if (end > len) {
                end = len;
            }
            if (newtxt == null) {
                newtxt = "";
            }
            this.setText(txt.substring(0, start) + newtxt + txt.substring(end));
            this.setSelectionRange(start, isHighLight ? start + newtxt.length() : start);
        }
    }

    public void setSelectionRange(int start, int end) {
        if (start <= end) {
            this.response("setAttr", (AuResponse)new AuSetAttribute((Component)this, "z.sel", start + "," + end));
        }
    }

    protected void checkUserError() throws WrongValueException {
        if (this._errmsg != null) {
            throw this.showCustomError(new WrongValueException((Component)this, this._errmsg));
        }
        if (!this._valided && this._constr != null) {
            this.setText(this.coerceToString(this._value));
        }
    }

    public String getAreaText() {
        return XMLs.encodeText((String)this.coerceToString(this._value));
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    public WrongValueException onWrongValue(WrongValueException ex) {
        this._errmsg = Exceptions.getMessage((Throwable)ex);
        return this.showCustomError(ex);
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InputableX,
    Errorable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)InputElement.this);
        }

        public boolean setTextByClient(String value) throws WrongValueException {
            InputElement.this._txtByClient = value;
            try {
                Object oldval = InputElement.this._value;
                InputElement.this.setText(value);
                boolean bl = oldval != InputElement.this._value;
                return bl;
            }
            catch (WrongValueException ex) {
                InputElement.this._errmsg = ex.getMessage();
                throw ex;
            }
            finally {
                InputElement.this._txtByClient = null;
            }
        }

        public void setErrorByClient(String value, String msg) {
            InputElement.this._errmsg = msg != null && msg.length() > 0 ? msg : null;
        }
    }
}

