/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.LabelImageElement;

public class Toolbarbutton
extends LabelImageElement
implements org.zkoss.zul.api.Toolbarbutton {
    private String _orient = "horizontal";
    private String _dir = "normal";
    private String _href;
    private String _target;
    private int _tabindex = -1;
    private boolean _disabled = false;

    public Toolbarbutton() {
    }

    public Toolbarbutton(String label) {
        this.setLabel(label);
    }

    public Toolbarbutton(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        String added = this.isDisabled() ? this.getZclass() + "-disd" : "";
        return scls != null && scls.length() > 0 ? scls + " " + added : added;
    }

    public String getZclass() {
        return this._zclass == null ? "z-toolbar-button" : this._zclass;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getDir() {
        return this._dir;
    }

    public void setDir(String dir) throws WrongValueException {
        if (!"normal".equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)this._dir, (Object)dir)) {
            this._dir = dir;
            this.invalidate();
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.invalidate();
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        this.appendAsapAttr(sb, "onRightClick");
        if (this._href == null) {
            sb.append(" href=\"javascript:;\"");
        } else {
            sb.append(" href=\"").append(this.getDesktop().getExecution().encodeURL(this._href)).append('\"');
        }
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)true);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"target", (String)this._target);
        if (this._tabindex >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
        }
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }
}

