/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.util.media.RepeatableMedia;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.impl.Utils;

public class Flash
extends HtmlBasedComponent
implements org.zkoss.zul.api.Flash {
    private String _src;
    private Media _media;
    private String _wmode = "transparent";
    private String _bgcolor;
    private byte _medver;
    private boolean _autoplay = true;
    private boolean _loop;

    public Flash() {
    }

    public Flash(String src) {
        this.setSrc(src);
    }

    public String getBgcolor() {
        return this._bgcolor;
    }

    public void setBgcolor(String bgcolor) {
        if (!Objects.equals((Object)this._bgcolor, (Object)bgcolor)) {
            this._bgcolor = bgcolor;
            this.smartUpdate("bgcolor", bgcolor);
        }
    }

    public boolean isLoop() {
        return this._loop;
    }

    public void setLoop(boolean loop) {
        if (this._loop != loop) {
            this._loop = loop;
            this.smartUpdate("loop", loop);
        }
    }

    public boolean isAutoPlay() {
        return this.isAutoplay();
    }

    public void setAutoPlay(boolean autoplay) {
        this.setAutoplay(autoplay);
    }

    public boolean isAutoplay() {
        return this._autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        if (this._autoplay != autoplay) {
            this._autoplay = autoplay;
            this.smartUpdate("play", autoplay);
        }
    }

    public String getWmode() {
        return this._wmode;
    }

    public void setWmode(String wmode) {
        if (!Objects.equals((Object)this._wmode, (Object)wmode)) {
            this._wmode = wmode;
            this.smartUpdate("wmode", wmode);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._media != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._media = null;
            this.invalidate();
        }
    }

    public void setContent(Media media) {
        if (this._src != null || media != this._media) {
            this._media = RepeatableMedia.getInstance((Media)media);
            this._src = null;
            if (this._media != null) {
                this._medver = (byte)(this._medver + 1);
            }
            this.invalidate();
        }
    }

    public Media getContent() {
        return this._media;
    }

    public String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._media != null ? this.getMediaSrc() : (dt != null && this._src != null ? dt.getExecution().encodeURL(this._src) : "");
    }

    private String getMediaSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._medver, this._media.getName(), this._media.getFormat());
    }
}

