/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Updatable;
import org.zkoss.zul.SimpleDateConstraint;
import org.zkoss.zul.au.in.TimeZoneCommand;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.mesg.MZul;

public class Datebox
extends FormatInputElement
implements org.zkoss.zul.api.Datebox {
    private TimeZone _tzone;
    private List _dtzones;
    private boolean _compact;
    private boolean _btnVisible = true;
    private boolean _lenient = true;
    private boolean _dtzonesReadonly = false;

    public Datebox() {
        this.setFormat(this.getDefaultFormat());
        this.setCols(11);
        this._compact = "zh".equals(Locales.getCurrent().getLanguage());
    }

    public Datebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    protected String getDefaultFormat() {
        String fmt;
        DateFormat df = DateFormat.getDateInstance(2, Locales.getCurrent());
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null && !"M/d/yy h:mm a".equals(fmt)) {
            return fmt;
        }
        return "yyyy/MM/dd";
    }

    public boolean isLenient() {
        return this._lenient;
    }

    public void setLenient(boolean lenient) {
        if (this._lenient != lenient) {
            this._lenient = lenient;
            this.smartUpdate("z.lenient", this._lenient);
        }
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setCompact(boolean compact) {
        if (this._compact != compact) {
            this._compact = compact;
            this.invalidate();
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("z.btnVisi", visible);
        }
    }

    public String getImage() {
        return null;
    }

    public void setImage(String img) {
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getTargetValue();
    }

    public void setValue(Date value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setFormat(String format) throws WrongValueException {
        if (format == null || format.length() == 0) {
            format = this.getDefaultFormat();
        } else {
            this.getDateFormat(format);
        }
        super.setFormat(format);
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        if (this._tzone != tzone) {
            this._tzone = this._dtzones != null ? (this._dtzones.contains(tzone) ? tzone : (TimeZone)this._dtzones.get(0)) : tzone;
            this.invalidate();
        }
    }

    public void setTimeZone(String id) {
        TimeZone tzone = TimeZone.getTimeZone(id);
        this.setTimeZone(tzone);
    }

    public List getDisplayedTimeZones() {
        return this._dtzones;
    }

    public void setDisplayedTimeZones(List dtzones) {
        if (dtzones != null && dtzones.isEmpty()) {
            dtzones = null;
        }
        if (this._dtzones != dtzones) {
            this._dtzones = dtzones;
            if (this._tzone == null && this._dtzones != null && this._dtzones.get(0) != null) {
                this._tzone = (TimeZone)this._dtzones.get(0);
            }
            this.invalidate();
        }
    }

    public void setDisplayedTimeZones(String dtzones) {
        if (dtzones == null || dtzones.length() == 0) {
            this.setDisplayedTimeZones((List)null);
            return;
        }
        LinkedList<TimeZone> list = new LinkedList<TimeZone>();
        String[] ids = dtzones.split(",");
        for (int i = 0; i < ids.length; ++i) {
            TimeZone tzone = TimeZone.getTimeZone(ids[i].trim());
            if (tzone == null) continue;
            list.add(tzone);
        }
        this.setDisplayedTimeZones(list);
    }

    public boolean isTimeZonesReadonly() {
        return this._dtzonesReadonly;
    }

    public void setTimeZonesReadonly(boolean readonly) {
        if (readonly != this._dtzonesReadonly) {
            this._dtzonesReadonly = readonly;
            this.smartUpdate("z.dtzonesReadonly", this._dtzonesReadonly);
        }
    }

    public void setOpen(boolean open) {
        if (open) {
            this.open();
        } else {
            this.close();
        }
    }

    public void open() {
        this.response("dropdn", (AuResponse)new AuInvoke((Component)this, "dropdn", true));
    }

    public void close() {
        this.response("dropdn", (AuResponse)new AuInvoke((Component)this, "dropdn", false));
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleDateConstraint(constr) : null);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getFormat();
        DateFormat df = this.getDateFormat(fmt);
        df.setLenient(this._lenient);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    public String getZclass() {
        return this._zclass == null ? "z-datebox" : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this.getDisplayedTimeZones() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onTimeZoneChange", (boolean)true);
        }
        if (this.getConstraint() instanceof SimpleDateConstraint) {
            SimpleDateConstraint st = (SimpleDateConstraint)this.getConstraint();
            Date d = st.getBeginDate();
            if (d != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.bd", (long)(d.getTime() / 1000L));
            }
            if ((d = st.getEndDate()) != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ed", (long)(d.getTime() / 1000L));
            }
        }
        if (!this._lenient) {
            sb.append(" z.lenient=\"false\"");
        }
        if (this._compact) {
            sb.append(" z.compact=\"true\"");
        }
        if (this._dtzones != null) {
            sb.append(" z.dtzones=\"");
            for (int i = 0; i < this._dtzones.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                TimeZone tz = (TimeZone)this._dtzones.get(i);
                sb.append(tz.getID());
            }
            sb.append("\"");
        }
        if (this.getTimeZone() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dtimezone", (String)this.getTimeZone().getID());
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dtzonesReadonly", (boolean)this._dtzonesReadonly);
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }

    protected boolean shallServerFormat() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        new TimeZoneCommand("onTimeZoneChange", 8);
    }

    protected class ExtraCtrl
    extends InputElement.ExtraCtrl
    implements Updatable {
        protected ExtraCtrl() {
            super(Datebox.this);
        }

        public void setResult(Object result) {
            String id = (String)result;
            TimeZone tzone = TimeZone.getTimeZone(id);
            Datebox.this.setTimeZone(tzone);
        }
    }
}

