/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.render.Floating;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zul.Splitter;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Box
extends XulElement
implements org.zkoss.zul.api.Box {
    private String _spacing;
    private String _align = "start";
    private String _pack = "start";
    private String[] _sizes;

    public Box() {
        this("vertical");
    }

    public Box(String orient) {
        this.setOrient(orient);
    }

    public Box(Component[] children) {
        this("vertical", children);
    }

    public Box(String orient, Component[] children) {
        this(orient);
        if (children != null) {
            for (int j = 0; j < children.length; ++j) {
                this.appendChild(children[j]);
            }
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public String getOrient() {
        return this.getMold();
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        this.setMold(orient);
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null && spacing.length() == 0) {
            spacing = null;
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.invalidate();
        }
    }

    public String getValign() {
        return Box.toValign(this.isVertical() ? this.getPack() : this.getAlign());
    }

    public void setValign(String valign) {
        String string = valign == null ? null : ("top".equals(valign) ? "start" : ("middle".equals(valign) ? "center" : (valign = "bottom".equals(valign) ? "end" : valign)));
        if (this.isVertical()) {
            this.setPack(valign);
        } else {
            this.setAlign(valign);
        }
    }

    private static String toValign(String v) {
        return v == null ? null : ("start".equals(v) ? "top" : ("center".equals(v) ? "middle" : ("end".equals(v) ? "bottom" : v)));
    }

    private static String toHalign(String v) {
        return v == null ? null : ("start".equals(v) ? "left" : ("end".equals(v) ? "right" : v));
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            if (this.isVertical()) {
                this.invalidate();
            } else {
                this.smartUpdate("valign", Box.toValign(align));
            }
        }
    }

    public String getPack() {
        return this._pack;
    }

    public void setPack(String pack) {
        if (!Objects.equals((Object)this._pack, (Object)pack)) {
            this._pack = pack;
            this.invalidate();
        }
    }

    public String getWidths() {
        return Utils.arrayToString(this._sizes);
    }

    public String getHeights() {
        return this.getWidths();
    }

    public void setWidths(String widths) throws WrongValueException {
        String[] sizes = Utils.stringToArray(widths, null);
        if (!Objects.equals((Object)sizes, (Object)this._sizes)) {
            this._sizes = sizes;
            this.invalidate();
        }
    }

    public void setHeights(String heights) throws WrongValueException {
        this.setWidths(heights);
    }

    public String getChildOuterAttrs(Component child) {
        StringBuffer sb = new StringBuffer(64).append(" z.coexist=\"true\"");
        boolean vert = this.isVertical();
        if (child instanceof Splitter) {
            sb.append(" class=\"").append(((Splitter)child).getZclass()).append("-outer\"");
            if (!child.isVisible()) {
                sb.append(" style=\"display:none\"");
            }
            return sb.toString();
        }
        if (vert) {
            Object xc;
            HTMLs.appendAttribute((StringBuffer)sb, (String)"valign", (String)Box.toValign(this._pack));
            if (!(child.isVisible() || (xc = ((ComponentCtrl)child).getExtraCtrl()) instanceof Floating && ((Floating)xc).isFloating())) {
                sb.append(" style=\"display:none\"");
            }
        }
        return sb.toString();
    }

    public String getChildInnerAttrs(Component child) {
        boolean visible;
        Object xc;
        boolean vert = this.isVertical();
        if (child instanceof Splitter) {
            return vert ? " class=\"" + ((Splitter)child).getZclass() + "-outer-td\"" : "";
        }
        StringBuffer sb = new StringBuffer(64);
        String align = Box.toHalign(vert ? this._align : this._pack);
        if (align != null && align.length() > 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)align);
        }
        String size = null;
        if (this._sizes != null) {
            int j = 0;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (child == o) {
                    size = this._sizes[j];
                    break;
                }
                if (o instanceof Splitter || ++j < this._sizes.length) continue;
                break;
            }
        }
        boolean floating = (xc = ((ComponentCtrl)child).getExtraCtrl()) instanceof Floating && ((Floating)xc).isFloating();
        boolean bl = visible = vert || floating || child.isVisible();
        if (size != null || floating || !visible) {
            sb.append(" style=\"");
            if (!visible) {
                sb.append("display:none;");
            }
            if (floating || size != null) {
                sb.append(vert ? "height" : "width").append(':').append(floating ? "0" : size);
            }
            sb.append('\"');
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof Splitter)) continue;
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.hasSplt", (boolean)true);
            break;
        }
        if ("vertical".equals(this.getOrient())) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vert", (String)"true");
        }
        return sb.toString();
    }

    public String getCaveAttrs() {
        if (this.isVertical()) {
            return "";
        }
        String valign = Box.toValign(this._align);
        return valign != null ? " valign=\"" + valign + '\"' : null;
    }

    public String getZclass() {
        return this._zclass == null ? (this.isVertical() ? "z-vbox" : "z-hbox") : this._zclass;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (super.insertBefore(newChild, refChild)) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.invalidate();
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        throw new InternalError();
    }
}

