/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.CometEvent;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.CometEventImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class CometConnectionManagerValve
extends ValveBase
implements Lifecycle,
HttpSessionListener,
LifecycleListener {
    protected static final String info = "org.apache.catalina.valves.CometConnectionManagerValve/1.0";
    protected StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean started = false;
    protected ConcurrentHashMap<String, ConnectionInfo[]> connections = new ConcurrentHashMap();

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container instanceof Context) {
            ((Lifecycle)((Object)this.container)).addLifecycleListener(this);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ((Lifecycle)((Object)this.container)).removeLifecycleListener(this);
        }
        for (ConnectionInfo[] connectionInfos : this.connections.values()) {
            if (connectionInfos == null) continue;
            for (int i = 0; i < connectionInfos.length; ++i) {
                ConnectionInfo connectionInfo = connectionInfos[i];
                try {
                    connectionInfo.event.close();
                    continue;
                }
                catch (Exception e) {
                    this.container.getLogger().warn((Object)this.sm.getString("cometConnectionManagerValve.event"), (Throwable)e);
                }
            }
        }
        this.connections.clear();
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "before_stop") {
            for (ConnectionInfo[] connectionInfos : this.connections.values()) {
                if (connectionInfos == null) continue;
                for (int i = 0; i < connectionInfos.length; ++i) {
                    ConnectionInfo connectionInfo = connectionInfos[i];
                    try {
                        ((CometEventImpl)connectionInfo.event).setEventType(CometEvent.EventType.END);
                        ((CometEventImpl)connectionInfo.event).setEventSubType(CometEvent.EventSubType.WEBAPP_RELOAD);
                        this.getNext().event(connectionInfo.request, connectionInfo.response, connectionInfo.event);
                        connectionInfo.event.close();
                        continue;
                    }
                    catch (Exception e) {
                        this.container.getLogger().warn((Object)this.sm.getString("cometConnectionManagerValve.event"), (Throwable)e);
                    }
                }
            }
            this.connections.clear();
        }
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (request.isComet() && !response.isClosed()) {
            HttpSession session = request.getSession(true);
            ConnectionInfo newConnectionInfo = new ConnectionInfo();
            newConnectionInfo.request = request;
            newConnectionInfo.response = response;
            newConnectionInfo.event = request.getEvent();
            HttpSession httpSession = session;
            synchronized (httpSession) {
                String id = session.getId();
                ConnectionInfo[] connectionInfos = this.connections.get(id);
                if (connectionInfos == null) {
                    connectionInfos = new ConnectionInfo[]{newConnectionInfo};
                    this.connections.put(id, connectionInfos);
                } else {
                    ConnectionInfo[] newConnectionInfos = new ConnectionInfo[connectionInfos.length + 1];
                    for (int i = 0; i < connectionInfos.length; ++i) {
                        newConnectionInfos[i] = connectionInfos[i];
                    }
                    newConnectionInfos[connectionInfos.length] = newConnectionInfo;
                    this.connections.put(id, newConnectionInfos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        block16: {
            HttpSession httpSession;
            HttpSession session2;
            boolean ok = false;
            try {
                this.getNext().event(request, response, event);
                ok = true;
                Object var6_5 = null;
                if (ok && !response.isClosed() && event.getEventType() != CometEvent.EventType.END && (event.getEventType() != CometEvent.EventType.ERROR || event.getEventSubType() == CometEvent.EventSubType.TIMEOUT)) break block16;
                httpSession = session2 = request.getSession(true);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!ok || response.isClosed() || event.getEventType() == CometEvent.EventType.END || event.getEventType() == CometEvent.EventType.ERROR && event.getEventSubType() != CometEvent.EventSubType.TIMEOUT) {
                    HttpSession session2;
                    HttpSession httpSession2 = session2 = request.getSession(true);
                    synchronized (httpSession2) {
                        ConnectionInfo[] connectionInfos = this.connections.get(session2.getId());
                        if (connectionInfos != null) {
                            boolean found = false;
                            for (int i = 0; !found && i < connectionInfos.length; ++i) {
                                found = connectionInfos[i].request == request;
                            }
                            if (found) {
                                ConnectionInfo[] newConnectionInfos = new ConnectionInfo[connectionInfos.length - 1];
                                int pos = 0;
                                for (int i = 0; i < connectionInfos.length; ++i) {
                                    if (connectionInfos[i].request == request) continue;
                                    newConnectionInfos[pos++] = connectionInfos[i];
                                }
                                this.connections.put(session2.getId(), newConnectionInfos);
                            }
                        }
                    }
                }
                throw throwable;
            }
            synchronized (httpSession) {
                ConnectionInfo[] connectionInfos = this.connections.get(session2.getId());
                if (connectionInfos != null) {
                    boolean found = false;
                    for (int i = 0; !found && i < connectionInfos.length; ++i) {
                        found = connectionInfos[i].request == request;
                    }
                    if (found) {
                        ConnectionInfo[] newConnectionInfos = new ConnectionInfo[connectionInfos.length - 1];
                        int pos = 0;
                        for (int i = 0; i < connectionInfos.length; ++i) {
                            if (connectionInfos[i].request == request) continue;
                            newConnectionInfos[pos++] = connectionInfos[i];
                        }
                        this.connections.put(session2.getId(), newConnectionInfos);
                    }
                }
            }
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        ConnectionInfo[] connectionInfos = this.connections.remove(se.getSession().getId());
        if (connectionInfos != null) {
            for (int i = 0; i < connectionInfos.length; ++i) {
                ConnectionInfo connectionInfo = connectionInfos[i];
                try {
                    ((CometEventImpl)connectionInfo.event).setEventType(CometEvent.EventType.END);
                    ((CometEventImpl)connectionInfo.event).setEventSubType(CometEvent.EventSubType.SESSION_END);
                    this.getNext().event(connectionInfo.request, connectionInfo.response, connectionInfo.event);
                    connectionInfo.event.close();
                    continue;
                }
                catch (Exception e) {
                    this.container.getLogger().warn((Object)this.sm.getString("cometConnectionManagerValve.event"), (Throwable)e);
                }
            }
        }
    }

    protected class ConnectionInfo {
        public CometEvent event;
        public Request request;
        public Response response;

        protected ConnectionInfo() {
        }
    }
}

