/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zkex.zul.Borderlayout;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public abstract class LayoutRegion
extends XulElement
implements org.zkoss.zkex.zul.api.LayoutRegion {
    private boolean _flex;
    private boolean _splittable;
    private boolean _collapsible;
    private boolean _open = true;
    private boolean _autoscroll;
    private String _border = "normal";
    private String _title = null;
    private int _maxsize = 2000;
    private int _minsize = 0;
    private int[] _margins = new int[]{0, 0, 0, 0};
    private int[] _cmargins = new int[]{5, 5, 5, 5};

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.invalidate();
        }
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!this._border.equals(border)) {
            this._border = border;
            this.smartUpdate("class", this.getRealSclass());
        }
    }

    public boolean isSplittable() {
        return this._splittable;
    }

    public void setSplittable(boolean splittable) {
        if (this._splittable != splittable) {
            this._splittable = splittable;
            this.smartUpdate("z.splt", this._splittable);
        }
    }

    public void setMaxsize(int maxsize) {
        if (this._maxsize != maxsize) {
            this._maxsize = maxsize;
            this.smartUpdate("z.maxs", this._maxsize);
        }
    }

    public int getMaxsize() {
        return this._maxsize;
    }

    public void setMinsize(int minsize) {
        if (this._minsize != minsize) {
            this._minsize = minsize;
            this.smartUpdate("z.mins", this._minsize);
        }
    }

    public int getMinsize() {
        return this._minsize;
    }

    public final boolean isFlex() {
        return this._flex;
    }

    public void setFlex(boolean flex) {
        if (this._flex != flex) {
            this._flex = flex;
            this.invalidate();
        }
    }

    public String getMargins() {
        return Utils.intsToString((int[])this._margins);
    }

    public void setMargins(String margins) {
        int[] imargins = Utils.stringToInts((String)margins, (int)0);
        if (!Objects.equals((Object)imargins, (Object)this._margins)) {
            this._margins = imargins;
            this.smartUpdate("z.mars", Utils.intsToString((int[])this._margins));
        }
    }

    public String getCmargins() {
        return Utils.intsToString((int[])this._cmargins);
    }

    public void setCmargins(String cmargins) {
        int[] imargins = Utils.stringToInts((String)cmargins, (int)0);
        if (!Objects.equals((Object)imargins, (Object)this._cmargins)) {
            this._cmargins = imargins;
            this.smartUpdate("z.cmars", Utils.intsToString((int[])this._cmargins));
        }
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (collapsible != this._collapsible) {
            this._collapsible = collapsible;
            this.smartUpdate("z.colps", this._collapsible);
        }
    }

    public boolean isAutoscroll() {
        return this._autoscroll;
    }

    public void setAutoscroll(boolean autoscroll) {
        if (this._autoscroll != autoscroll) {
            this._autoscroll = autoscroll;
            this.smartUpdate("z.autoscl", this._autoscroll);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z.open", open);
        }
    }

    public abstract String getPosition();

    public abstract void setSize(String var1);

    public abstract String getSize();

    protected void addSclass(String cls) {
        String sclass = this.getSclass();
        if (!this.hasSclass(cls)) {
            this.setSclass(sclass == null ? cls : cls + " " + sclass);
        }
    }

    protected boolean hasSclass(String cls) {
        String sclass = this.getSclass();
        if (sclass == null) {
            sclass = "";
        }
        return cls == null || (" " + sclass + " ").indexOf(" " + cls + " ") > -1;
    }

    protected void removeSclass(String cls) {
        String sclass = this.getSclass();
        if (sclass != null && cls != null && this.hasSclass(cls)) {
            this.setSclass(sclass.replaceAll("(?:^|\\s+)" + cls + "(?:\\s+|$)", " ").trim());
        }
    }

    protected String getRealSclass() {
        String cls = super.getRealSclass();
        String added = "normal".equals(this.getBorder()) ? "" : this.getZclass() + "-noborder";
        return cls != null ? cls + " " + added : added;
    }

    public String getZclass() {
        return this._zclass == null ? "z-" + this.getPosition() : this._zclass;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.smartUpdate("z.cid", "zk_n_a");
        if (child instanceof Borderlayout) {
            this.setFlex(false);
            this.removeSclass(this.getZclass() + "-nested");
        }
    }

    public void onChildAdded(Component child) {
        this.smartUpdate("z.cid", child.getUuid());
        super.onChildAdded(child);
        if (child instanceof Borderlayout) {
            this.setFlex(true);
            this.addSclass(this.getZclass() + "-nested");
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (this.getChildren().size() > 0) {
            throw new UiException("Only one child is allowed: " + this);
        }
        super.beforeChildAdded(child, refChild);
    }

    public void invalidate() {
        super.invalidate();
        Borderlayout layout = (Borderlayout)this.getParent();
        if (layout != null) {
            layout.resize();
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Borderlayout)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onOpen");
        this.appendAsapAttr(sb, "onSize");
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cid", (String)(this.getChildren().isEmpty() ? "zk_n_a" : ((Component)this.getChildren().get(0)).getUuid()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pos", (String)this.getPosition());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.flex", (boolean)this.isFlex());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.mars", (String)this.getMargins());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cmars", (String)this.getCmargins());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.colps", (boolean)this.isCollapsible());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.open", (boolean)this.isOpen());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.splt", (boolean)this.isSplittable());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.maxs", (int)this.getMaxsize());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.mins", (int)this.getMinsize());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.autoscl", (boolean)this.isAutoscroll());
        return sb.toString();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)LayoutRegion.this);
        }

        public void setOpenByClient(boolean open) {
            LayoutRegion.this._open = open;
        }
    }
}

