package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;
import static java.lang.Math.*;
import javax.vecmath.Vector3d;

/**
 * タイマーループに処理を割り込ませる、つまりAcerola3Dのメインのタイマー
 * の起動時に確実に処理を実行する方法。
 */
public class TimerLoopTaskTest implements Runnable {
    static Action3D a3;
    public static void main(String[] args) throws Exception {
        A3Window w = new A3Window(800,800);
        Action3D b = new Action3D("x-res:///background7.a3");
        b.setLoc(0,-2,0);
        w.setBackground(b);
        for (double x=-1.0;x<1.1;x++)
            for (double y=-1.0;y<1.1;y++)
                for (double z=-1.0;z<1.1;z++) {
                    a3 = new Action3D("x-res:///vesma9.a3");
                    a3.setLoc(x,y,z);
                    a3.change("walk");
                    w.add(a3);
                }
        a3 = new Action3D("x-res:///axis.a3");
        w.add(a3);
        w.setAvatar(a3);
        Vector3d lookAt = new Vector3d(0.0,0.0,0.0);
        Vector3d camera = new Vector3d(3.0,0.0,0.0);
        Vector3d up = new Vector3d(0.0,1.0,0.0);
        w.setNavigationMode(A3CanvasInterface.NaviMode.CHASE,lookAt,camera,up,1.0);
        w.setCameraInterpolateRatio(0.000000000001);
        w.setUpdateInterval(33);
        w.insertTaskIntoTimerLoop(new TimerLoopTaskTest());
    }
    double t=0.0;
    public void run() {
        t = t + 0.01;
        a3.setLoc(10.0*cos(t),0,10.0*sin(t));
        a3.setRot(0,-t,0);
        //double d=1.0;for (long i=0;i<100000000l;i++)d=d*Math.PI;
    }
}
