package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;

public class ProjectionTest extends A3Adapter {
    public ProjectionTest() throws Exception {
        A3Window w = new A3Window(300,300);
        w.setProjectionMode(ProjectionMode.PARALLEL);
        w.setCanvasWidthInPWorld(5.0);
        //w.setFieldOfView(Math.PI/2.0);
        w.setNavigationMode(A3CanvasInterface.NaviMode.WALK);
        w.addA3Listener(this);
        for (double x=-10.0;x<11.0;x=x+5.0) {
            for (double y=-10.0;y<11.0;y=y+5.0) {
                for (double z=-10.0;z<11.0;z=z+5.0) {
                    Action3D a3 = new Action3D("x-res:///axis.a3");
                    a3.setLoc(x,y,z);
                    a3.setLabel("A");
                    w.add(a3);
                }
            }
        }
    }
    public void mouseClicked(A3Event e) {
        A3Object a3 = e.getA3Object();
        if (a3 instanceof Action3D) {
            ((Action3D)a3).change("spin");
        }
    }
    public static void main(String args[]) throws Exception {
        new ProjectionTest();
    }
}
