package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.net.URL;

public class A3VideoCameraTest extends JComponent implements Runnable {
    private static final long serialVersionUID = 1L;
    A3VideoCamera videoCamera;
    BufferedImage image;

    public A3VideoCameraTest() throws Exception {
        A3Window w = new A3Window(300,300);
        w.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        a3.setScale(0.3);
        a3.setLoc(-0.5,0.0,0.0);
        a3.setRot(0.0,0.3,0.0);
        w.add(a3);

        videoCamera = new A3VideoCamera(256,256);
        URL url = new URL("x-rzip:x-res:///SonyZ1U.a3!/SonyZ1U.wrl");
        videoCamera.addNode(Util.loadVRML_B(url));
        videoCamera.setLoc(0.5,0.0,0.0);
        videoCamera.setRot(0.0,Math.PI/2.0,0.0);
        w.add(videoCamera);

        image = new BufferedImage(256,256,BufferedImage.TYPE_INT_RGB);

        this.setPreferredSize(new Dimension(256,256));
        JFrame f = new JFrame();
        f.add(this);
        f.pack();
        f.setLocation(300,0);
        f.setVisible(true);

        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(image,0,0,null);
        g.setColor(Color.red);
        g.drawString("A3VideoCamera Vision",10,10);
    }

    @Override
    public void run() {
        while (true) {
            videoCamera.renderOffscreenBuffer(image);
            repaint();
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }

    public static void main(String args[]) throws Exception {
        new A3VideoCameraTest();
    }
}
