package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;
import java.awt.*;
import java.awt.image.*;
import java.net.URL;
import javax.swing.*;
import javax.media.j3d.*;

public class A3EyeTest extends JComponent implements Runnable {
    private static final long serialVersionUID = 1L;
    A3EyeObj eye;
    BufferedImage image;
    public A3EyeTest() throws Exception {
        A3Window w = new A3Window(300,300);
        w.setLocation(0,0);
        //w.setCameraLocImmediately(0.0,0.0,5.0);
        w.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        a3.setScale(0.1);
        a3.setLoc(-0.3,0.0,0.0);
        a3.setRot(0.0,-0.3,0.0);
        w.add(a3);
        eye = new A3EyeObj();
        eye.setLoc(0.3,0.0,0.0);
        eye.setRot(0.0,Math.PI/2.0,0.0);
        w.add(eye);

        image = new BufferedImage(256,256,BufferedImage.TYPE_INT_RGB);

        this.setPreferredSize(new Dimension(256,256));

        JFrame f = new JFrame();
        f.add(this);
        f.pack();
        f.setLocation(300,0);
        f.setVisible(true);

        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(image,0,0,null);
        //g.drawImage(image,0,255,255,0,0,0,255,255,null);
        g.setColor(Color.red);
        g.drawString("eye vision",10,10);
    }

    public void run() {
        while (true) {
            eye.renderOffscreenBuffer(image);
            repaint();
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }

    public static void main(String args[]) throws Exception {
        new A3EyeTest();
    }
}


class A3EyeObj extends A3Object {
    A3Eye a3Eye;

    public A3EyeObj() throws Exception {
        super(new A3InitData("A3EyeObj"));
        BranchGroup bg = new BranchGroup();
        a3Eye = new A3Eye(256,256);
        bg.addChild(a3Eye);
        URL url = new URL("x-rzip:x-res:///SonyZ1U.a3!/SonyZ1U.wrl");
        bg.addChild(Util.loadVRML_B(url));
        setNode(bg);
    }

    public void renderOffscreenBuffer(BufferedImage bi) {
        a3Eye.renderOffscreenBuffer(bi);
    }
}
