package a3test.demo;

import jp.sourceforge.acerola3d.a3.*;

public class Othello extends A3Adapter {
    public void start() throws Exception {
        A3Window w = new A3Window(500,300);
        w.addA3Listener(this);

        Action3D boardA3 = new Action3D("x-res:///board.a3");
        w.setBackground(boardA3);
        Action3D a[][] = new Action3D[8][8];
        for (int i=0;i<8;i++) {
            for (int j=0;j<8;j++) {
                a[i][j] = new Action3D("x-res:///othello.a3");
                a[i][j].setLoc(-0.105+0.03*i,0.0,-0.105+0.03*j);
                a[i][j].changeImmediately("n");
                w.add(a[i][j]);
            }
        }

        w.setCameraLoc(0.0,0.16,0.35);
        w.setCameraRot(-0.45,0.0,0.0);
        w.setCameraScale(0.1);
    }
    public void mouseClicked(A3Event e){
        A3Object a3 = e.getA3Object();
        if (a3 instanceof Action3D) {
            ((Action3D)a3).change("w2b");
        }
    }

    public static void main(String args[]) throws Exception {
        new Othello().start();
    }
}
