package a3test.autocontrol;

import jp.sourceforge.acerola3d.a3.*;
import jp.sourceforge.acerola3d.A23;
import javax.vecmath.*;

public class BillboardTest {
    public static void main(String args[]) throws Exception {
        A23.setDefaultUpperDirection(A3Object.UpperDirection.Y);
        //A23.setDefaultUpperDirection(A3Object.UpperDirection.Z);
        A3Window w = new A3Window(300,300);
        Action3D a3_1 = new Action3D("x-res:///Smiley.a3");
        a3_1.setEnableBehavior(true);
        a3_1.setBillboardControl(true);
        w.add(a3_1);
        Action3D a3_2 = new Action3D("x-res:///Smiley.a3");
        a3_2.setLoc(2.0,0.0,0.0);
        w.add(a3_2);
        Action3D a3_3 = new Action3D("x-res:///Smiley.a3");
        a3_3.setLoc(-2.0,0.0,0.0);
        w.add(a3_3);
        double t = 0.0;
        while (true) {
            w.setCameraLoc(8.0*Math.sin(t),0.5,8.0*Math.cos(t));
            //w.setCameraLoc(8.0*Math.sin(t),-8.0*Math.cos(t),0.5);
            Quat4d q = new Quat4d(0.0,1.0*Math.sin(t/2.0),0.0,Math.cos(t/2.0));
            //Quat4d p = new Quat4d(1.0*Math.sin(Math.PI/4.0),0.0,0.0,Math.cos(Math.PI/4.0));
            //Quat4d q = new Quat4d(0.0,0.0,1.0*Math.sin(t/2.0),Math.cos(t/2.0));
            //q.mul(p);
            w.setCameraQuat(q);
            Thread.sleep(100);
            t=t+0.05;
        }
    }
}
