#include <Inventor/Qt/SoQt.h>// 󥤥󥯥롼ɤ
#include <Inventor/Qt/SoQtRenderArea.h>
#include <Inventor/manips/SoTrackballManip.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>


int main(int argc, char** argv)
{
  // InventorQtν
  QWidget * window = SoQt::init(argv[0]);
  if (!window)
    return(0);

  // Υ롼Ⱥ
  SoSeparator *root = new SoSeparator;
  root->ref();

  // ʻˤƥ롼Ȥɲ
  SoPerspectiveCamera *camera = new SoPerspectiveCamera;
  root->addChild(camera);

  // 饤Ȥȥȥåܡޥ˥ԥ졼ɲ
  root->addChild(new SoDirectionalLight);
  root->addChild(new SoTrackballManip);

  // ޥƥꥢ롼Ȥɲ
  SoMaterial *material = new SoMaterial;
  material->diffuseColor.setValue(0.0, 0.0, 1.0);
  root->addChild(material);

  // ɲ
  root->addChild(new SoCylinder);

  // ɽΰơɲä
  SoQtRenderArea *renderArea = new SoQtRenderArea(window);
  camera->viewAll(root, renderArea->getViewportRegion());
  renderArea->setSceneGraph(root);
  renderArea->setTitle("Cylinder with Trackball");
  renderArea->show();

  // ᥤ󥦥ɥɽơ٥ȥϥɥ󥰳
  SoQt::show(window);
  SoQt::mainLoop();
}
