%{
#include <stdio.h>
%}
%token HIERARCHY
%token ROOT
%token OFFSET
%token CHANNELS
%token JOINT
%token X_POSITION
%token Y_POSITION
%token Z_POSITION
%token X_ROTATION
%token Y_ROTATION
%token Z_ROTATION
%token X_SCALE
%token Y_SCALE
%token Z_SCALE
%token END_SITE
%token L_BRACE
%token R_BRACE
%token MOTION
%token FRAMES
%token FRAME_TIME
%token IDENTIFIER
%token INTEGER
%token REAL_NUMBER
%%
bvh             : hierarchy_part motion_part { printf("bvh\n"); }
                ;
hierarchy_part  : HIERARCHY root_block { printf("hierarchy_part\n"); }
                ;
root_block      : ROOT IDENTIFIER L_BRACE offset_line channels_line super_blocks R_BRACE { printf("root_block\n"); }
                ;
super_blocks    : super_block
                | super_block super_blocks
                ;
offset_line     : OFFSET number number number { printf("offset_line\n"); }
                ;
number          : INTEGER { printf("number[INTEGER]\n"); }
                | REAL_NUMBER { printf("number[REAL_NUMBER]\n"); }
                ;
channels_line   : CHANNELS INTEGER channel_types { printf("channels_line\n"); }
                ;
channel_types   : 
                | channel_type channel_types
                ;
channel_type    : X_POSITION { printf("channel_type[X_POSITION]\n"); }
                | Y_POSITION { printf("channel_type[Y_POSITION]\n"); }
                | Z_POSITION { printf("channel_type[Z_POSITION]\n"); }
                | X_ROTATION { printf("channel_type[X_ROTATION]\n"); }
                | Y_ROTATION { printf("channel_type[Y_ROTATION]\n"); }
                | Z_ROTATION { printf("channel_type[Z_ROTATION]\n"); }
                | X_SCALE { printf("channel_type[X_SCALE]\n"); }
                | Y_SCALE { printf("channel_type[Y_SCALE]\n"); }
                | Z_SCALE { printf("channel_type[Z_SCALE]\n"); }
                ;
super_block     : joint_block { printf("super_block[joint_block]\n"); }
                | end_site_block { printf("super_block[end_site_block]\n"); }
                ;
joint_block     : JOINT IDENTIFIER L_BRACE offset_line channels_line super_blocks R_BRACE { printf("joint_block\n"); }
                ;
end_site_block  : END_SITE L_BRACE offset_line R_BRACE { printf("end_site_block\n"); }
                ;
motion_part     : MOTION frames_line frame_time_line numbers { printf("motion_part\n"); }
                ;
numbers         :
                | number numbers
                ;
frames_line     : FRAMES INTEGER { printf("frames_line\n"); }
                ;
frame_time_line : FRAME_TIME number { printf("frame_time_line\n"); }
                ;
%%
yyerror(){}
main()
{yyparse();}
#include "lex.yy.c"
