package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.*;
import jp.sourceforge.acerola3d.sound.*;
import javax.vecmath.*;

public class SoundPanel extends JPanel implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3Sound sound;
    JButton playPauseB;
    public SoundPanel(String urlString) {
        setLayout(new BorderLayout());
        playPauseB = new JButton("play");
        playPauseB.addActionListener(this);
        add(playPauseB,BorderLayout.CENTER);
        if (urlString!=null) {
            try {
                A3SoundSystem ss = A3SoundSystem.getDefaultSoundSystem();
                Vector3d offset = new Vector3d();
                Vector3d dir = new Vector3d(0.0,0.0,1.0);
                sound = ss.load(urlString,0.0f,A3SoundType.BackgroundSound,1.0f,true,offset,dir);
            } catch(Exception e) {
                e.printStackTrace();
            }
        }
    }
    public void loadSound(String urlString) {
        A3SoundSystem ss = A3SoundSystem.getDefaultSoundSystem();
        try {
            Vector3d offset = new Vector3d();
            Vector3d dir = new Vector3d(0.0,0.0,1.0);
            sound = ss.load(urlString,0.0f,A3SoundType.BackgroundSound,1.0f,true,offset,dir);
            playPauseB.setText("play");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void loadSound(File f) {
        try {
            String urlString = f.toURI().toURL().toString();
            loadSound(urlString);
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (playPauseB.getText().equals("play")) {
            sound.start();
            playPauseB.setText("stop");
        } else {
            sound.stop();
            playPauseB.setText("play");
        }
        
    }
    public void clear() {
        if (sound!=null) {
            sound.stop();
            //sound.cleanUp();
        }
    }
}
